package org.eclipse.emf.examples.generator.validator.templates.model;

import org.eclipse.emf.codegen.ecore.genmodel.*;
import org.eclipse.emf.examples.generator.validator.ValidatorGeneratorUtil;

public class ModelDescription
{
  protected static String nl;
  public static synchronized ModelDescription create(String lineSeparator)
  {
    nl = lineSeparator;
    ModelDescription result = new ModelDescription();
    nl = null;
    return result;
  }

  public final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "Model ";
  protected final String TEXT_2 = NL + NL + "This model description is not a real EMF artifact. It was generated by the" + NL + "org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's" + NL + "code generator can be extended." + NL + "This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false." + NL;
  protected final String TEXT_3 = NL + "Contains packages:";
  protected final String TEXT_4 = NL + "  ";
  protected final String TEXT_5 = " <";
  protected final String TEXT_6 = ">";
  protected final String TEXT_7 = NL;
  protected final String TEXT_8 = NL + "Package ";
  protected final String TEXT_9 = " <";
  protected final String TEXT_10 = ">" + NL;
  protected final String TEXT_11 = NL + "  Class ";
  protected final String TEXT_12 = NL + "    ";
  protected final String TEXT_13 = " ";
  protected final String TEXT_14 = "/";
  protected final String TEXT_15 = " : ";
  protected final String TEXT_16 = NL + "    Operation ";
  protected final String TEXT_17 = " : ";
  protected final String TEXT_18 = NL;
  protected final String TEXT_19 = NL + "  Enum ";
  protected final String TEXT_20 = NL + "    Literal ";
  protected final String TEXT_21 = " = ";
  protected final String TEXT_22 = NL;
  protected final String TEXT_23 = NL + "  DataType ";
  protected final String TEXT_24 = " <";
  protected final String TEXT_25 = ">" + NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    GenModel genModel = (GenModel)argument;
    stringBuffer.append(TEXT_1);
    stringBuffer.append(genModel.getModelName());
    stringBuffer.append(TEXT_2);
    if (genModel.getGenPackages().size() > 1) {
    stringBuffer.append(TEXT_3);
    for (GenPackage genPackage : genModel.getGenPackages()) {
    stringBuffer.append(TEXT_4);
    stringBuffer.append(genPackage.getPackageName());
    stringBuffer.append(TEXT_5);
    stringBuffer.append(genPackage.getNSURI());
    stringBuffer.append(TEXT_6);
    }
    stringBuffer.append(TEXT_7);
    }
    for (GenPackage genPackage : genModel.getGenPackages()) {
    stringBuffer.append(TEXT_8);
    stringBuffer.append(genPackage.getPackageName());
    stringBuffer.append(TEXT_9);
    stringBuffer.append(genPackage.getNSURI());
    stringBuffer.append(TEXT_10);
    for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
    if (genClassifier instanceof GenClass) { GenClass genClass = (GenClass)genClassifier;
    stringBuffer.append(TEXT_11);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(ValidatorGeneratorUtil.getSuperTypesExpression(genClass));
    for (GenFeature genFeature : genClass.getGenFeatures()) {
    String keyword = genFeature.isReferenceType() ? "Reference" : "Attribute";
    stringBuffer.append(TEXT_12);
    stringBuffer.append(keyword);
    stringBuffer.append(TEXT_13);
    if (genFeature.isDerived()) {
    stringBuffer.append(TEXT_14);
    }
    stringBuffer.append(genFeature.getName());
    stringBuffer.append(TEXT_15);
    stringBuffer.append(ValidatorGeneratorUtil.getTypeExpression(genFeature));
    }
    for (GenOperation genOperation : genClass.getGenOperations()) {
    stringBuffer.append(TEXT_16);
    stringBuffer.append(genOperation.getName());
    stringBuffer.append(ValidatorGeneratorUtil.getParameterExpression(genOperation));
    stringBuffer.append(TEXT_17);
    stringBuffer.append(ValidatorGeneratorUtil.getTypeExpression(genOperation));
    }
    stringBuffer.append(TEXT_18);
    } else if (genClassifier instanceof GenEnum) { GenEnum genEnum = (GenEnum)genClassifier;
    stringBuffer.append(TEXT_19);
    stringBuffer.append(genEnum.getName());
    for (GenEnumLiteral genEnumLiteral : genEnum.getGenEnumLiterals()) {
    stringBuffer.append(TEXT_20);
    stringBuffer.append(genEnumLiteral.getName());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(genEnumLiteral.getValue());
    }
    stringBuffer.append(TEXT_22);
    } else if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    stringBuffer.append(TEXT_23);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_24);
    stringBuffer.append(genDataType.getEcoreDataType().getInstanceClassName());
    stringBuffer.append(TEXT_25);
    }
    }
    }
    return stringBuffer.toString();
  }
}
