/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ShapeSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final Shape shape;

    public ShapeSetConstraintCommand(Shape shape, ChangeBoundsRequest req, Rectangle newBounds) {
        if (shape == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
        this.request = req;
        this.newBounds = newBounds.getCopy();
        this.setLabel("move / resize");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.shape.getLocation(), this.shape.getSize());
        this.redo();
    }

    public void redo() {
        this.shape.setSize(this.newBounds.getSize());
        this.shape.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.shape.setSize(this.oldBounds.getSize());
        this.shape.setLocation(this.oldBounds.getLocation());
    }
}

