/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.internal.GraphLabel;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class GraphNode
extends GraphItem {
    public static final int HIGHLIGHT_NONE = 0;
    public static final int HIGHLIGHT_ON = 1;
    private int nodeStyle;
    private List sourceConnections;
    private List targetConnections;
    private Color foreColor;
    private Color backColor;
    private Color highlightColor;
    private Color borderColor;
    private Color borderHighlightColor;
    private int borderWidth;
    private Point currentLocation;
    protected Dimension size;
    private Font font;
    private boolean cacheLabel;
    private boolean visible = true;
    private LayoutEntity layoutEntity;
    protected Graph graph;
    protected IContainer parent;
    protected Object internalNode;
    private boolean selected;
    protected int highlighted = 0;
    private IFigure tooltip;
    protected IFigure nodeFigure;
    private boolean isDisposed = false;
    private boolean hasCustomTooltip;
    static int count = 0;
    private IFigure fishEyeFigure = null;
    private Font fishEyeFont = null;
    private boolean isFisheyeEnabled;

    public GraphNode(IContainer graphModel, int style) {
        this(graphModel, style, null);
    }

    public GraphNode(IContainer graphModel, int style, Object data) {
        this(graphModel.getGraph(), style, "", null, data);
    }

    public GraphNode(IContainer graphModel, int style, String text) {
        this(graphModel, style, text, null);
    }

    public GraphNode(IContainer graphModel, int style, String text, Object data) {
        this(graphModel.getGraph(), style, text, null, data);
    }

    public GraphNode(IContainer graphModel, int style, String text, Image image) {
        this(graphModel, style, text, image, null);
    }

    public GraphNode(IContainer graphModel, int style, String text, Image image, Object data) {
        super((Widget)graphModel.getGraph(), style, data);
        this.initModel(graphModel, text, image);
        if (this.nodeFigure == null) {
            this.initFigure();
        }
        if (this.parent.getItemType() == 0) {
            ((Graph)this.parent).addNode(this);
        } else if (this.parent.getItemType() == 3) {
            ((GraphContainer)this.parent).addNode(this);
        }
        this.parent.getGraph().registerItem(this);
    }

    protected void initFigure() {
        this.nodeFigure = this.createFigureForModel();
    }

    protected void initModel(IContainer parent, String text, Image image) {
        this.nodeStyle |= parent.getGraph().getNodeStyle();
        this.parent = parent;
        this.sourceConnections = new ArrayList();
        this.targetConnections = new ArrayList();
        this.foreColor = parent.getGraph().DARK_BLUE;
        this.backColor = parent.getGraph().LIGHT_BLUE;
        this.highlightColor = parent.getGraph().HIGHLIGHT_COLOR;
        this.nodeStyle = 0;
        this.borderColor = ColorConstants.lightGray;
        this.borderHighlightColor = ColorConstants.blue;
        this.borderWidth = 1;
        this.currentLocation = new PrecisionPoint(0, 0);
        this.size = new Dimension(-1, -1);
        this.font = Display.getDefault().getSystemFont();
        this.graph = parent.getGraph();
        this.cacheLabel = false;
        this.setText(text);
        this.layoutEntity = new LayoutGraphNode();
        if (image != null) {
            this.setImage(image);
        }
        if (this.font == null) {
            this.font = Display.getDefault().getSystemFont();
        }
    }

    public String toString() {
        return "GraphModelNode: " + this.getText();
    }

    public LayoutEntity getLayoutEntity() {
        return this.layoutEntity;
    }

    public void dispose() {
        GraphConnection connection;
        if (this.isFisheyeEnabled) {
            this.fishEye(false, false);
        }
        super.dispose();
        this.isDisposed = true;
        while (this.getSourceConnections().size() > 0) {
            connection = (GraphConnection)((Object)this.getSourceConnections().get(0));
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeSourceConnection(connection);
        }
        while (this.getTargetConnections().size() > 0) {
            connection = (GraphConnection)((Object)this.getTargetConnections().get(0));
            if (!connection.isDisposed()) {
                connection.dispose();
                continue;
            }
            this.removeTargetConnection(connection);
        }
        this.graph.removeNode(this);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean isSizeFixed() {
        return this.size.width >= 0 || this.size.height >= 0;
    }

    public List getSourceConnections() {
        return new ArrayList(this.sourceConnections);
    }

    public List getTargetConnections() {
        return new ArrayList(this.targetConnections);
    }

    Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    public Point getLocation() {
        return this.currentLocation;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setLocation(double x, double y) {
        this.currentLocation.x = (int)x;
        this.currentLocation.y = (int)y;
        this.refreshLocation();
    }

    public Dimension getSize() {
        if (this.size.height < 0 && this.size.width < 0 && this.nodeFigure != null) {
            return this.nodeFigure.getSize().getCopy();
        }
        return this.size.getCopy();
    }

    public Color getForegroundColor() {
        return this.foreColor;
    }

    public void setForegroundColor(Color c) {
        this.foreColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color c) {
        this.backColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setTooltip(IFigure tooltip) {
        this.hasCustomTooltip = true;
        this.tooltip = tooltip;
        this.updateFigureForModel(this.nodeFigure);
    }

    public IFigure getTooltip() {
        return this.tooltip;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setBorderHighlightColor(Color c) {
        this.borderHighlightColor = c;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color c) {
        this.highlightColor = c;
    }

    public void highlight() {
        if (this.highlighted == 1) {
            return;
        }
        if (this.parent.getItemType() == 3) {
            ((GraphContainer)this.parent).highlightNode(this);
        } else {
            ((Graph)this.parent).highlightNode(this);
        }
        this.highlighted = 1;
        this.updateFigureForModel(this.getNodeFigure());
    }

    public void unhighlight() {
        if (this.highlighted == 0) {
            return;
        }
        if (this.parent.getItemType() == 3) {
            ((GraphContainer)this.parent).unhighlightNode(this);
        } else {
            ((Graph)this.parent).unhighlightNode(this);
        }
        this.highlighted = 0;
        this.updateFigureForModel(this.nodeFigure);
    }

    protected void refreshLocation() {
        Point loc = this.getLocation();
        Dimension size = this.getSize();
        Rectangle bounds = new Rectangle(loc, size);
        if (this.nodeFigure == null || this.nodeFigure.getParent() == null) {
            return;
        }
        this.nodeFigure.getParent().setConstraint(this.nodeFigure, (Object)bounds);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.updateFigureForModel(this.nodeFigure);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateFigureForModel(this.nodeFigure);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        super.setText(string);
        if (this.nodeFigure != null) {
            this.updateFigureForModel(this.nodeFigure);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (this.nodeFigure != null) {
            this.updateFigureForModel(this.nodeFigure);
        }
    }

    public Graph getGraphModel() {
        return this.graph;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
        this.cacheLabel = (this.nodeStyle & 2) > 0;
    }

    public void setSize(double width, double height) {
        if (width != (double)this.size.width || height != (double)this.size.height) {
            this.size.width = (int)width;
            this.size.height = (int)height;
            this.refreshLocation();
        }
    }

    public Color getBorderHighlightColor() {
        return this.borderHighlightColor;
    }

    public boolean cacheLabel() {
        return this.cacheLabel;
    }

    public void setCacheLabel(boolean cacheLabel) {
        this.cacheLabel = cacheLabel;
    }

    public IFigure getNodeFigure() {
        return this.nodeFigure;
    }

    public void setVisible(boolean visible) {
        GraphConnection connection;
        this.visible = visible;
        this.getFigure().setVisible(visible);
        List sConnections = this.getSourceConnections();
        List tConnections = this.getTargetConnections();
        Iterator iterator2 = sConnections.iterator();
        while (iterator2.hasNext()) {
            connection = (GraphConnection)((Object)iterator2.next());
            connection.setVisible(visible);
        }
        iterator2 = tConnections.iterator();
        while (iterator2.hasNext()) {
            connection = (GraphConnection)((Object)iterator2.next());
            connection.setVisible(visible);
        }
    }

    public int getStyle() {
        return super.getStyle() | this.getNodeStyle();
    }

    protected IFigure fishEye(boolean enable, boolean animate) {
        if (this.isDisposed) {
            return null;
        }
        if (!this.checkStyle(4)) {
            return null;
        }
        if (enable) {
            this.fishEyeFigure = this.createFishEyeFigure();
            Rectangle rectangle = this.nodeFigure.getBounds().getCopy();
            FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
            fontData.setHeight(12);
            this.fishEyeFont = new Font((Device)Display.getCurrent(), fontData);
            this.fishEyeFigure.setFont(this.fishEyeFont);
            Dimension newSize = this.fishEyeFigure.getPreferredSize();
            Rectangle currentSize = rectangle.getCopy();
            this.nodeFigure.translateToAbsolute((Translatable)currentSize);
            int expandedH = (newSize.height - currentSize.height) / 2 + 1;
            int expandedW = (newSize.width - currentSize.width) / 2 + 1;
            Dimension expandAmount = new Dimension(expandedW, expandedH);
            this.nodeFigure.translateToAbsolute((Translatable)rectangle);
            rectangle.expand(new Insets(expandAmount.height, expandAmount.width, expandAmount.height, expandAmount.width));
            if (expandedH <= 0 && expandedW <= 0) {
                return null;
            }
            this.getGraphModel().fishEye(this.nodeFigure, this.fishEyeFigure, rectangle, true);
            if (this.fishEyeFigure != null) {
                this.isFisheyeEnabled = true;
            }
            return this.fishEyeFigure;
        }
        this.getGraphModel().removeFishEye(this.fishEyeFigure, this.nodeFigure, animate);
        if (this.fishEyeFont != null) {
            this.fishEyeFont.dispose();
            this.fishEyeFont = null;
        }
        this.isFisheyeEnabled = false;
        return null;
    }

    IContainer getParent() {
        return this.parent;
    }

    boolean isHighlighted() {
        return this.highlighted > 0;
    }

    void invokeLayoutListeners(LayoutConstraint constraint) {
        this.graph.invokeConstraintAdapters((Object)this, constraint);
    }

    protected void updateFigureForModel(IFigure currentFigure) {
        IFigure newFisheyeFigure;
        IFigure toolTip;
        if (currentFigure == null) {
            return;
        }
        if (!(currentFigure instanceof GraphLabel)) {
            return;
        }
        GraphLabel figure = (GraphLabel)currentFigure;
        if (!this.checkStyle(8)) {
            figure.setText(this.getText());
        }
        figure.setIcon(this.getImage());
        if (this.highlighted == 1) {
            figure.setForegroundColor(this.getForegroundColor());
            figure.setBackgroundColor(this.getHighlightColor());
            figure.setBorderColor(this.getBorderHighlightColor());
        } else {
            figure.setForegroundColor(this.getForegroundColor());
            figure.setBackgroundColor(this.getBackgroundColor());
            figure.setBorderColor(this.getBorderColor());
        }
        figure.setBorderWidth(this.getBorderWidth());
        figure.setFont(this.getFont());
        if (this.getTooltip() == null && !this.hasCustomTooltip) {
            toolTip = new Label();
            ((Label)toolTip).setText(this.getText());
        } else {
            toolTip = this.getTooltip();
        }
        figure.setToolTip(toolTip);
        this.refreshLocation();
        if (this.isFisheyeEnabled && this.graph.replaceFishFigure(this.fishEyeFigure, newFisheyeFigure = this.createFishEyeFigure())) {
            this.fishEyeFigure = newFisheyeFigure;
        }
    }

    protected IFigure createFigureForModel() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        label.setFont(this.font);
        if (this.checkStyle(8)) {
            label.setText("");
        }
        this.updateFigureForModel((IFigure)label);
        return label;
    }

    private IFigure createFishEyeFigure() {
        GraphNode node = this;
        boolean cacheLabel = this.cacheLabel();
        GraphLabel label = new GraphLabel(node.getText(), node.getImage(), cacheLabel);
        if (!this.checkStyle(8)) {
            label.setText(this.getText());
        }
        label.setIcon(this.getImage());
        if (this.highlighted == 1) {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getHighlightColor());
        } else {
            label.setForegroundColor(this.getForegroundColor());
            label.setBackgroundColor(this.getBackgroundColor());
        }
        label.setFont(this.getFont());
        return label;
    }

    public boolean isVisible() {
        return this.visible;
    }

    void addSourceConnection(GraphConnection connection) {
        this.sourceConnections.add(connection);
    }

    void addTargetConnection(GraphConnection connection) {
        this.targetConnections.add(connection);
    }

    void removeSourceConnection(GraphConnection connection) {
        this.sourceConnections.remove((Object)connection);
    }

    void removeTargetConnection(GraphConnection connection) {
        this.targetConnections.remove((Object)connection);
    }

    void setSelected(boolean selected) {
        selected = this.isSelected();
        if (selected) {
            return;
        }
        if (selected) {
            this.highlight();
        } else {
            this.unhighlight();
        }
        this.selected = selected;
    }

    public int getItemType() {
        return 1;
    }

    IFigure getFigure() {
        if (this.nodeFigure == null) {
            this.initFigure();
        }
        return this.getNodeFigure();
    }

    void paint() {
    }

    class LayoutGraphNode
    implements LayoutEntity {
        Object layoutInformation = null;

        LayoutGraphNode() {
        }

        public double getHeightInLayout() {
            return GraphNode.this.getSize().height;
        }

        public Object getLayoutInformation() {
            return this.layoutInformation;
        }

        public String toString() {
            return GraphNode.this.getText();
        }

        public double getWidthInLayout() {
            return GraphNode.this.getSize().width;
        }

        public double getXInLayout() {
            return GraphNode.this.getLocation().x;
        }

        public double getYInLayout() {
            return GraphNode.this.getLocation().y;
        }

        public void populateLayoutConstraint(LayoutConstraint constraint) {
            GraphNode.this.invokeLayoutListeners(constraint);
        }

        public void setLayoutInformation(Object internalEntity) {
            this.layoutInformation = internalEntity;
        }

        public void setLocationInLayout(double x, double y) {
            GraphNode.this.setLocation(x, y);
        }

        public void setSizeInLayout(double width, double height) {
            GraphNode.this.setSize(width, height);
        }

        public int compareTo(Object otherNode) {
            int rv = 0;
            if (otherNode instanceof GraphNode) {
                GraphNode node = (GraphNode)((Object)otherNode);
                if (GraphNode.this.getText() != null) {
                    rv = GraphNode.this.getText().compareTo(node.getText());
                }
            }
            return rv;
        }

        public Object getGraphData() {
            return GraphNode.this;
        }

        public void setGraphData(Object o) {
        }
    }
}

