/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;

public class NonResizableEditPolicy
extends SelectionHandlesEditPolicy {
    private IFigure focusRect;
    private IFigure feedback;
    private boolean isDragAllowed = true;

    protected IFigure createDragSourceFeedbackFigure() {
        RectangleFigure r = new RectangleFigure();
        FigureUtilities.makeGhostShape((Shape)r);
        r.setLineStyle(3);
        r.setForegroundColor(ColorConstants.white);
        r.setBounds(this.getInitialFeedbackBounds());
        this.addFeedback((IFigure)r);
        return r;
    }

    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        if (this.isDragAllowed()) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        } else {
            NonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list, new SelectEditPartTracker(this.getHost()), SharedCursors.ARROW);
        }
        return list;
    }

    public void deactivate() {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
            this.feedback = null;
        }
        this.hideFocus();
        super.deactivate();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.feedback != null) {
            this.removeFeedback(this.feedback);
        }
        this.feedback = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "clone".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("move".equals(type) && this.isDragAllowed()) {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        if ("orphan".equals(type)) {
            return this.getOrphanCommand(request);
        }
        if ("align".equals(type)) {
            return this.getAlignCommand((AlignmentRequest)request);
        }
        return null;
    }

    protected IFigure getDragSourceFeedbackFigure() {
        if (this.feedback == null) {
            this.feedback = this.createDragSourceFeedbackFigure();
        }
        return this.feedback;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        AlignmentRequest req = new AlignmentRequest("align children");
        req.setEditParts(this.getHost());
        req.setAlignment(request.getAlignment());
        req.setAlignmentRectangle(request.getAlignmentRectangle());
        return this.getHost().getParent().getCommand(req);
    }

    protected Rectangle getInitialFeedbackBounds() {
        if (((GraphicalEditPart)this.getHost()).getFigure() instanceof HandleBounds) {
            return ((HandleBounds)((GraphicalEditPart)this.getHost()).getFigure()).getHandleBounds();
        }
        return ((GraphicalEditPart)this.getHost()).getFigure().getBounds();
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest("move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        return this.getHost().getParent().getCommand(req);
    }

    protected Command getOrphanCommand(Request req) {
        return null;
    }

    protected void hideFocus() {
        if (this.focusRect != null) {
            this.removeFeedback(this.focusRect);
        }
        this.focusRect = null;
    }

    public boolean isDragAllowed() {
        return this.isDragAllowed;
    }

    public void setDragAllowed(boolean isDragAllowed) {
        if (isDragAllowed == this.isDragAllowed) {
            return;
        }
        this.isDragAllowed = isDragAllowed;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    protected void showFocus() {
        this.focusRect = new AbstractHandle((GraphicalEditPart)this.getHost(), new Locator(){

            public void relocate(IFigure target) {
                IFigure figure = NonResizableEditPolicy.this.getHostFigure();
                Rectangle r = figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds().getCopy() : NonResizableEditPolicy.this.getHostFigure().getBounds().getResized(-1, -1);
                NonResizableEditPolicy.this.getHostFigure().translateToAbsolute((Translatable)r);
                target.translateToRelative((Translatable)r);
                target.setBounds(r.expand(5, 5).resize(1, 1));
            }
        }){
            {
                this.setBorder((Border)new FocusBorder());
            }

            protected DragTracker createDragTracker() {
                return null;
            }
        };
        this.addFeedback(this.focusRect);
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "add children".equals(request.getType()) || "clone".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public boolean understandsRequest(Request request) {
        if ("move".equals(request.getType())) {
            return this.isDragAllowed();
        }
        if ("clone".equals(request.getType()) || "add children".equals(request.getType()) || "orphan".equals(request.getType()) || "align".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

