/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Rectangle;

public class PuristicScrollPane
extends ScrollPane {
    protected void createVerticalScrollBar() {
        PuristicScrollBar verticalScrollBar = new PuristicScrollBar(false);
        this.setVerticalScrollBar(verticalScrollBar);
    }

    protected void createHorizontalScrollBar() {
        PuristicScrollBar horizontalScrollBar = new PuristicScrollBar(true);
        this.setHorizontalScrollBar(horizontalScrollBar);
    }

    protected void paintChildren(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        int i = 0;
        while (i < this.getChildren().size()) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (child.isVisible() && child.intersects(graphics.getClip(clip))) {
                graphics.clipRect(this.getBounds());
                child.paint(graphics);
                graphics.restoreState();
            }
            ++i;
        }
    }

    public void invalidate() {
        this.getUpdateManager().addDirtyRegion(this, this.getBounds());
        super.invalidate();
    }

    public class PuristicScrollBar
    extends ScrollBar {
        public PuristicScrollBar(boolean isHorizontal) {
            this.setHorizontal(isHorizontal);
        }

        protected Clickable createDefaultDownButton() {
            Clickable buttonDown = super.createDefaultDownButton();
            buttonDown.setBorder(null);
            buttonDown.setOpaque(false);
            return buttonDown;
        }

        protected IFigure createDefaultThumb() {
            return null;
        }

        protected Clickable createDefaultUpButton() {
            Clickable buttonUp = super.createDefaultUpButton();
            buttonUp.setBorder(null);
            buttonUp.setOpaque(false);
            return buttonUp;
        }

        protected Clickable createPageDown() {
            return null;
        }

        protected Clickable createPageUp() {
            return null;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() instanceof RangeModel) {
                this.getButtonDown().setVisible(this.getValue() != this.getMaximum() - this.getExtent());
                this.getButtonUp().setVisible(this.getValue() != this.getMinimum());
            }
            super.propertyChange(event);
        }
    }
}

