/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicNumberCellEditorValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class LocationPropertySource
implements IPropertySource {
    public static final String ID_XPOS = "xPos";
    public static final String ID_YPOS = "yPos";
    protected static IPropertyDescriptor[] descriptors;
    protected Point point = null;

    static {
        TextPropertyDescriptor xProp = new TextPropertyDescriptor((Object)ID_XPOS, LogicMessages.LocationPropertySource_Property_X_Label);
        xProp.setValidator((ICellEditorValidator)LogicNumberCellEditorValidator.instance());
        TextPropertyDescriptor yProp = new TextPropertyDescriptor((Object)ID_YPOS, LogicMessages.LocationPropertySource_Property_Y_Label);
        yProp.setValidator((ICellEditorValidator)LogicNumberCellEditorValidator.instance());
        descriptors = new IPropertyDescriptor[]{xProp, yProp};
    }

    public LocationPropertySource(Point point) {
        this.point = point.getCopy();
    }

    public Object getEditableValue() {
        return this.point.getCopy();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propName) {
        if (ID_XPOS.equals(propName)) {
            return Integer.toString(this.point.x);
        }
        if (ID_YPOS.equals(propName)) {
            return Integer.toString(this.point.y);
        }
        return null;
    }

    public boolean isPropertySet(Object propName) {
        return ID_XPOS.equals(propName) || ID_YPOS.equals(propName);
    }

    public void resetPropertyValue(Object propName) {
    }

    public void setPropertyValue(Object propName, Object value) {
        if (ID_XPOS.equals(propName)) {
            this.point.x = Integer.parseInt((String)value);
        }
        if (ID_YPOS.equals(propName)) {
            this.point.y = Integer.parseInt((String)value);
        }
    }

    public String toString() {
        return new String("[" + this.point.x + "," + this.point.y + "]");
    }
}

