/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.LEDEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LogicLabelEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LogicResizableEditPolicy;
import org.eclipse.gef.examples.logicdesigner.edit.OutputEditPart;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LabelFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;
import org.eclipse.gef.examples.logicdesigner.figures.LogicFlowFeedbackFigure;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.commands.AddCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.ChangeGuideCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CloneCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.SetConstraintCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;

public class LogicXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public LogicXYLayoutEditPolicy(XYLayout layout) {
        this.setXyLayout(layout);
    }

    protected Command chainGuideAttachmentCommand(Request request, LogicSubpart part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos != null) {
            int alignment = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalAttachment" : "SnapToGuides.VerticalAttachment");
            ChangeGuideCommand cgm = new ChangeGuideCommand(part, horizontal);
            cgm.setNewGuide(this.findGuideAt(guidePos, horizontal), alignment);
            result = result.chain((Command)cgm);
        }
        return result;
    }

    protected Command chainGuideDetachmentCommand(Request request, LogicSubpart part, Command cmd, boolean horizontal) {
        Command result = cmd;
        Integer guidePos = (Integer)request.getExtendedData().get(horizontal ? "SnapToGuides.HorizontalGuide" : "SnapToGuides.VerticalGuide");
        if (guidePos == null) {
            result = result.chain((Command)new ChangeGuideCommand(part, horizontal));
        }
        return result;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createAddCommand(Request request, EditPart childEditPart, Object constraint) {
        LogicSubpart part = (LogicSubpart)childEditPart.getModel();
        Rectangle rect = (Rectangle)constraint;
        AddCommand add = new AddCommand();
        add.setParent((LogicDiagram)this.getHost().getModel());
        add.setChild(part);
        add.setLabel(LogicMessages.LogicXYLayoutEditPolicy_AddCommandLabelText);
        add.setDebugLabel("LogicXYEP add subpart");
        SetConstraintCommand setConstraint = new SetConstraintCommand();
        setConstraint.setLocation(rect);
        setConstraint.setPart(part);
        setConstraint.setLabel(LogicMessages.LogicXYLayoutEditPolicy_AddCommandLabelText);
        setConstraint.setDebugLabel("LogicXYEP setConstraint");
        Command cmd = add.chain(setConstraint);
        cmd = this.chainGuideAttachmentCommand(request, part, cmd, true);
        cmd = this.chainGuideAttachmentCommand(request, part, cmd, false);
        cmd = this.chainGuideDetachmentCommand(request, part, cmd, true);
        return this.chainGuideDetachmentCommand(request, part, cmd, false);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        int edgeBeingResized;
        int alignment;
        Integer guidePos;
        SetConstraintCommand cmd = new SetConstraintCommand();
        LogicSubpart part = (LogicSubpart)child.getModel();
        cmd.setPart(part);
        cmd.setLocation((Rectangle)constraint);
        SetConstraintCommand result = cmd;
        if ((request.getResizeDirection() & 5) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            } else if (part.getHorizontalGuide() != null) {
                alignment = part.getHorizontalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 1) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, true));
                }
            }
        }
        if ((request.getResizeDirection() & 0x18) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
            if (guidePos != null) {
                result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            } else if (part.getVerticalGuide() != null) {
                alignment = part.getVerticalGuide().getAlignment(part);
                edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 8) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    result = result.chain(new ChangeGuideCommand(part, false));
                }
            }
        }
        if (request.getType().equals("move children") || request.getType().equals("align children")) {
            result = this.chainGuideAttachmentCommand((Request)request, part, result, true);
            result = this.chainGuideAttachmentCommand((Request)request, part, result, false);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, true);
            result = this.chainGuideDetachmentCommand((Request)request, part, result, false);
        }
        return result;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof LEDEditPart || child instanceof OutputEditPart) {
            LogicResizableEditPolicy policy = new LogicResizableEditPolicy();
            policy.setResizeDirections(0);
            return policy;
        }
        if (child instanceof LogicLabelEditPart) {
            LogicResizableEditPolicy policy = new LogicResizableEditPolicy();
            policy.setResizeDirections(24);
            return policy;
        }
        return new LogicResizableEditPolicy();
    }

    protected IFigure createSizeOnDropFeedback(CreateRequest createRequest) {
        Object figure;
        if (createRequest.getNewObject() instanceof Circuit) {
            figure = new CircuitFeedbackFigure();
        } else if (createRequest.getNewObject() instanceof LogicFlowContainer) {
            figure = new LogicFlowFeedbackFigure();
        } else if (createRequest.getNewObject() instanceof LogicLabel) {
            figure = new LabelFeedbackFigure();
        } else {
            figure = new RectangleFigure();
            figure.setXOR(true);
            figure.setFill(true);
            figure.setBackgroundColor(LogicColorConstants.ghostFillColor);
            figure.setForegroundColor(ColorConstants.white);
        }
        this.addFeedback((IFigure)figure);
        return figure;
    }

    protected LogicGuide findGuideAt(int pos, boolean horizontal) {
        RulerProvider provider = (RulerProvider)this.getHost().getViewer().getProperty(horizontal ? "vertical ruler" : "horizontal ruler");
        return (LogicGuide)provider.getGuideAt(pos);
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart childPart = (GraphicalEditPart)editParts.get(i);
            Rectangle r = childPart.getFigure().getBounds().getCopy();
            childPart.getFigure().translateToAbsolute((Translatable)r);
            r = request.getTransformedRectangle(r);
            this.getLayoutContainer().translateToRelative((Translatable)r);
            this.getLayoutContainer().translateFromParent((Translatable)r);
            r.translate(this.getLayoutOrigin().getNegated());
            Object constraint = this.getConstraintFor(r);
            command.add(this.createAddCommand(generic, (EditPart)childPart, this.translateToModelConstraint(constraint)));
            ++i;
        }
        return command.unwrap();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        CloneCommand clone = new CloneCommand();
        clone.setParent((LogicDiagram)this.getHost().getModel());
        Iterator i = request.getEditParts().iterator();
        GraphicalEditPart currPart = null;
        while (i.hasNext()) {
            currPart = (GraphicalEditPart)i.next();
            clone.addPart((LogicSubpart)currPart.getModel(), (Rectangle)this.getConstraintForClone(currPart, request));
        }
        Integer guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
        if (guidePos != null) {
            int hAlignment = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalAttachment");
            clone.setGuide(this.findGuideAt(guidePos, true), hAlignment, true);
        }
        if ((guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide")) != null) {
            int vAlignment = (Integer)request.getExtendedData().get("SnapToGuides.VerticalAttachment");
            clone.setGuide(this.findGuideAt(guidePos, false), vAlignment, false);
        }
        return clone;
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateCommand create = new CreateCommand();
        create.setParent((LogicDiagram)this.getHost().getModel());
        LogicSubpart newPart = (LogicSubpart)request.getNewObject();
        create.setChild(newPart);
        Rectangle constraint = (Rectangle)this.getConstraintFor(request);
        create.setLocation(constraint);
        create.setLabel(LogicMessages.LogicXYLayoutEditPolicy_CreateCommandLabelText);
        Command cmd = this.chainGuideAttachmentCommand((Request)request, newPart, create, true);
        return this.chainGuideAttachmentCommand((Request)request, newPart, cmd, false);
    }

    protected Insets getCreationFeedbackOffset(CreateRequest request) {
        if (request.getNewObject() instanceof LED || request.getNewObject() instanceof Circuit) {
            return new Insets(2, 0, 2, 0);
        }
        return new Insets();
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }
}

