/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.tools;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextCommand;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.TextUtilities;
import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleProvider;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.CaretSearch;
import org.eclipse.gef.examples.text.edit.TextStyleManager;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.examples.text.requests.TextRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;

public class TextTool
extends SelectionTool
implements StyleProvider {
    static final boolean IS_CARBON = "carbon".equals(SWT.getPlatform());
    private static final int MODE_BS = 2;
    private static final int MODE_DEL = 3;
    private static final int MODE_TYPING = 1;
    private CommandStackListener commandListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            TextTool.this.fireStyleChanges();
        }
    };
    private StyleListener listener;
    private AppendableCommand pendingCommand;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TextTool.this.fireStyleChanges();
        }
    };
    private List styleKeys = new ArrayList();
    private final StyleService styleService;
    private List styleValues = new ArrayList();
    private int textInputMode;
    private boolean isMirrored;
    private final GraphicalTextViewer textViewer;
    static /* synthetic */ Class class$0;

    public TextTool(GraphicalTextViewer viewer, StyleService service) {
        this.textViewer = viewer;
        this.styleService = service;
        this.isMirrored = (viewer.getControl().getStyle() & 0x8000000) != 0;
    }

    public void activate() {
        super.activate();
        this.styleService.setStyleProvider(this);
        this.textViewer.getEditDomain().getCommandStack().addCommandStackListener(this.commandListener);
        this.textViewer.addSelectionChangedListener(this.selectionListener);
    }

    public void addStyleListener(StyleListener listener) {
        Assert.isTrue((this.listener == null ? 1 : 0) != 0);
        this.listener = listener;
    }

    protected Cursor calculateCursor() {
        TextualEditPart textTarget;
        EditPart target = this.getTargetEditPart();
        if (target instanceof TextualEditPart && (textTarget = (TextualEditPart)target).acceptsCaret()) {
            return Cursors.IBEAM;
        }
        return super.calculateCursor();
    }

    public void deactivate() {
        this.setTextInputMode(0);
        this.styleService.setStyleProvider(null);
        this.textViewer.getEditDomain().getCommandStack().removeCommandStackListener(this.commandListener);
        this.textViewer.removeSelectionChangedListener(this.selectionListener);
        super.deactivate();
    }

    private void doAction(int action, KeyEvent event) {
        boolean append = false;
        switch (action) {
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 16908295: {
                append = true;
            }
            case 0x1000007: {
                this.doSelect(4, false, append);
                break;
            }
            case 17170436: {
                append = true;
            }
            case 0x1040004: {
                this.doSelect(3, true, append);
                break;
            }
            case 17170435: {
                append = true;
            }
            case 17039363: {
                this.doSelect(3, false, append);
                break;
            }
            case 16908296: {
                append = true;
            }
            case 0x1000008: {
                this.doSelect(4, true, append);
                break;
            }
            case 16908291: {
                append = true;
            }
            case 0x1000003: {
                this.doSelect(1, false, append);
                break;
            }
            case 16908292: {
                append = true;
            }
            case 0x1000004: {
                this.doSelect(1, true, append);
                break;
            }
            case 0x1020001: {
                append = true;
            }
            case 0x1000001: {
                this.doSelect(2, false, append);
                break;
            }
            case 0x1020002: {
                append = true;
            }
            case 0x1000002: {
                this.doSelect(2, true, append);
                break;
            }
            case 131081: {
                this.doUnindent();
                break;
            }
            case 9: {
                if (this.doIndent()) break;
                this.doTyping(event);
                break;
            }
            case 13: {
                if (this.doNewline()) break;
                this.doTyping(event);
                break;
            }
        }
    }

    private boolean doBackspace() {
        this.setTextInputMode(2);
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        if (range.isEmpty()) {
            if (this.handleTextEdit(new TextRequest("TextRequest.backspace", range, this.pendingCommand))) {
                return true;
            }
            this.doSelect(1, false, false);
            return false;
        }
        return this.handleTextEdit(new TextRequest("TextRequest.removeRange", range));
    }

    private boolean doDelete() {
        this.setTextInputMode(3);
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        if (range.isEmpty()) {
            if (this.handleTextEdit(new TextRequest("TextRequest.delete", range, this.pendingCommand))) {
                return true;
            }
            this.doSelect(1, true, false);
            return false;
        }
        return this.handleTextEdit(new TextRequest("TextRequest.removeRange", range));
    }

    /*
     * WARNING - void declaration
     */
    private boolean doIndent() {
        void var2_2;
        this.setTextInputMode(0);
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        if (!range.isEmpty()) {
            return false;
        }
        TextRequest edit = new TextRequest("TextRequest.indentText", range);
        return this.handleTextEdit((TextRequest)var2_2);
    }

    private boolean doInsertContent(char c) {
        this.setTextInputMode(1);
        TextRequest edit = new TextRequest(this.getTextualViewer().getSelectionRange(), Character.toString(c), this.pendingCommand);
        String[] keys = new String[this.styleKeys.size()];
        this.styleKeys.toArray(keys);
        edit.setStyles(keys, this.styleValues.toArray());
        return this.handleTextEdit(edit);
    }

    private void doKeyDown(KeyEvent event) {
        int action = 0;
        if (event.keyCode != 0) {
            action = this.lookupAction(event.keyCode | event.stateMask);
        } else {
            action = this.lookupAction(event.character | event.stateMask);
            if (action == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                int c = event.character + 64;
                action = this.lookupAction(c | event.stateMask);
            }
        }
        if (action == 0) {
            this.doTyping(event);
        } else {
            this.doAction(action, event);
        }
    }

    private boolean doNewline() {
        this.setTextInputMode(2);
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        Assert.isTrue((boolean)range.isEmpty());
        TextRequest edit = new TextRequest("TextRequest.newline", range, this.pendingCommand);
        return this.handleTextEdit(edit);
    }

    private void doSelect(int type, boolean isForward, boolean appendSelection) {
        TextLocation caretLocation = this.getTextualViewer().getCaretLocation();
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        TextLocation otherEnd = range.isForward ? range.begin : range.end;
        Rectangle caretBounds = this.getTextualViewer().getCaretBounds();
        CaretSearch search = new CaretSearch();
        search.isForward = isForward;
        search.type = type;
        search.x = caretBounds.x;
        search.baseline = caretBounds.y + caretBounds.height / 2;
        search.where = caretLocation;
        TextLocation newCaretLocation = caretLocation.part.getNextLocation(search);
        if (newCaretLocation == null) {
            return;
        }
        if (appendSelection) {
            range = TextUtilities.isForward(otherEnd, newCaretLocation) ? new SelectionRange(otherEnd, newCaretLocation, true) : new SelectionRange(newCaretLocation, otherEnd, false);
            this.getTextualViewer().setSelectionRange(range);
        } else if (search.isForward) {
            this.getTextualViewer().setSelectionRange(new SelectionRange(newCaretLocation, newCaretLocation, true));
        } else {
            this.getTextualViewer().setSelectionRange(new SelectionRange(newCaretLocation, newCaretLocation, false));
        }
    }

    private void doTyping(KeyEvent event) {
        boolean ignore = false;
        if (IS_CARBON) {
            ignore = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0;
        } else {
            boolean bl = ignore = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0;
        }
        if (!ignore && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
            this.doInsertContent(event.character);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doUnindent() {
        void var2_2;
        this.setTextInputMode(0);
        SelectionRange range = this.getTextualViewer().getSelectionRange();
        if (!range.isEmpty()) {
            return false;
        }
        TextRequest edit = new TextRequest("TextRequest.unindentText", range);
        return this.handleTextEdit((TextRequest)var2_2);
    }

    private void fireStyleChanges() {
        if (this.listener != null) {
            this.listener.styleChanged(null);
        }
    }

    private void flushStyles() {
        this.styleKeys.clear();
        this.styleValues.clear();
    }

    protected String getDebugName() {
        return "TextTool";
    }

    private Object getSelectionStyle(String styleID, boolean isState) {
        GraphicalTextViewer viewer = this.getTextualViewer();
        TextRequest req = new TextRequest("TextRequest.style", viewer.getSelectionRange());
        req.setStyles(new String[]{styleID}, new Object[1]);
        TextualEditPart target = this.getTextTarget(viewer, req);
        if (target == null) {
            return StyleService.UNDEFINED;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.examples.text.edit.TextStyleManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TextStyleManager manager = (TextStyleManager)target.getAdapter(clazz);
        if (isState) {
            return manager.getStyleState(styleID, viewer.getSelectionRange());
        }
        return manager.getStyleValue(styleID, viewer.getSelectionRange());
    }

    public Object getStyle(String styleID) {
        int i = 0;
        while (i < this.styleKeys.size()) {
            if (styleID.equals(this.styleKeys.get(i))) {
                return this.styleValues.get(i);
            }
            ++i;
        }
        return this.getSelectionStyle(styleID, false);
    }

    public Object getStyleState(String styleID) {
        return this.getSelectionStyle(styleID, true);
    }

    private TextualEditPart getTextTarget(GraphicalTextViewer viewer, Request request) {
        EditPart target;
        SelectionRange range = viewer.getSelectionRange();
        if (range == null) {
            return null;
        }
        EditPart candidate = ToolUtilities.findCommonAncestor((EditPart)range.begin.part, (EditPart)range.end.part);
        do {
            target = candidate.getTargetEditPart(request);
            candidate = candidate.getParent();
        } while (target == null && candidate != null);
        return (TextualEditPart)target;
    }

    GraphicalTextViewer getTextualViewer() {
        return this.textViewer;
    }

    protected boolean handleCommandStackChanged() {
        this.setTextInputMode(0);
        return super.handleCommandStackChanged();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.isInState(1)) {
            this.doKeyDown(e);
        }
        return super.handleKeyDown(e);
    }

    protected void handleKeyTraversed(TraverseEvent event) {
        if ((event.detail == 8 || event.detail == 16) && (event.stateMask & 0x40000) == 0) {
            event.doit = false;
        }
    }

    protected boolean handleMove() {
        super.handleMove();
        this.refreshCursor();
        return true;
    }

    private boolean handleTextEdit(TextRequest edit) {
        GraphicalTextViewer viewer = this.getTextualViewer();
        TextualEditPart target = this.getTextTarget(viewer, edit);
        Command insert = null;
        if (target != null) {
            insert = target.getCommand(edit);
        }
        if (insert == null) {
            return false;
        }
        if (this.pendingCommand == null || insert != this.pendingCommand) {
            if (!insert.canExecute()) {
                return false;
            }
            this.executeCommand(insert);
            this.pendingCommand = insert instanceof AppendableCommand ? (AppendableCommand)insert : null;
        } else {
            if (!this.pendingCommand.canExecutePending()) {
                return false;
            }
            this.pendingCommand.executePending();
            viewer.setSelectionRange(((TextCommand)((Object)this.pendingCommand)).getExecuteSelectionRange(viewer));
        }
        return true;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return viewer instanceof GraphicalTextViewer;
    }

    private int lookupAction(int i) {
        switch (i) {
            case 0x1000003: {
                return this.isMirrored ? 0x1000004 : 0x1000003;
            }
            case 0x1000004: {
                return this.isMirrored ? 0x1000003 : 0x1000004;
            }
            case 16908292: {
                return this.isMirrored ? 16908291 : 16908292;
            }
            case 16908291: {
                return this.isMirrored ? 16908292 : 16908291;
            }
            case 0x1040004: {
                return this.isMirrored ? 17039363 : 0x1040004;
            }
            case 17170436: {
                return this.isMirrored ? 17170435 : 17170436;
            }
            case 17039363: {
                return this.isMirrored ? 0x1040004 : 17039363;
            }
            case 17170435: {
                return this.isMirrored ? 17170436 : 17170435;
            }
            case 0x1000008: {
                return 0x1000008;
            }
            case 16908296: {
                return 16908296;
            }
            case 0x1000007: {
                return 0x1000007;
            }
            case 16908295: {
                return 16908295;
            }
            case 0x1000001: {
                return 0x1000001;
            }
            case 0x1000002: {
                return 0x1000002;
            }
            case 0x1000005: {
                return 0x1000005;
            }
            case 0x1020001: {
                return 0x1020001;
            }
            case 0x1020002: {
                return 0x1020002;
            }
            case 127: {
                return 127;
            }
            case 8: {
                return 8;
            }
            case 131081: {
                return 131081;
            }
            case 9: {
                return 9;
            }
            case 10: 
            case 13: {
                return 13;
            }
        }
        return 0;
    }

    public void removeStyleListener(StyleListener listener) {
        Assert.isTrue((this.listener == listener ? 1 : 0) != 0);
        this.listener = null;
    }

    public void setDragTracker(DragTracker newDragTracker) {
        if (this.getDragTracker() == newDragTracker) {
            return;
        }
        this.setTextInputMode(0);
        super.setDragTracker(newDragTracker);
    }

    public void setStyle(String styleID, Object newValue) {
        int prev;
        Object oldValue = this.getSelectionStyle(styleID, false);
        if (newValue.equals(oldValue) && (prev = this.styleKeys.indexOf(styleID)) != -1) {
            this.styleKeys.remove(prev);
            this.styleValues.remove(prev);
            return;
        }
        GraphicalTextViewer viewer = this.getTextualViewer();
        TextRequest req = new TextRequest("TextRequest.style", viewer.getSelectionRange());
        req.setStyles(new String[]{styleID}, new Object[]{newValue});
        TextualEditPart target = this.getTextTarget(viewer, req);
        Command c = target.getCommand(req);
        if (c == null) {
            int prev2 = this.styleKeys.indexOf(styleID);
            if (prev2 != -1) {
                this.styleKeys.remove(prev2);
                this.styleValues.remove(prev2);
            }
            this.styleKeys.add(0, styleID);
            this.styleValues.add(0, newValue);
        } else if (c.canExecute()) {
            this.executeCommand(c);
        }
    }

    private void setTextInputMode(int mode) {
        if (this.textInputMode != mode) {
            this.pendingCommand = null;
        }
        if (this.textInputMode != 1) {
            this.flushStyles();
        }
        this.textInputMode = mode;
    }
}

