/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.TextCommand;
import org.eclipse.gef.examples.text.actions.BooleanStyleAction;
import org.eclipse.gef.examples.text.actions.MultiStyleAction;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.BlockTextualPart;
import org.eclipse.gef.examples.text.edit.ContainerTreePart;
import org.eclipse.gef.examples.text.edit.DocumentPart;
import org.eclipse.gef.examples.text.edit.ImportPart;
import org.eclipse.gef.examples.text.edit.ImportsPart;
import org.eclipse.gef.examples.text.edit.InlineTextualPart;
import org.eclipse.gef.examples.text.edit.TextFlowPart;
import org.eclipse.gef.examples.text.edit.TextRunTreePart;
import org.eclipse.gef.examples.text.model.Block;
import org.eclipse.gef.examples.text.model.CanvasStyle;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.tools.TextTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TextEditor
extends GraphicalEditor {
    private Container doc;
    private StyleService styleService = new StyleService();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.doc.getStyle().setParentStyle(new CanvasStyle(this.getGraphicalViewer().getControl()));
        this.getEditDomain().setDefaultTool((Tool)new TextTool((GraphicalTextViewer)this.getGraphicalViewer(), this.styleService));
        this.getEditDomain().loadDefaultTool();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        ((FigureCanvas)this.getGraphicalViewer().getControl()).getViewport().setContentsTracksWidth(true);
    }

    protected void createActions() {
        super.createActions();
        IKeyBindingService service = this.getSite().getKeyBindingService();
        ActionRegistry registry = this.getActionRegistry();
        BooleanStyleAction action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.bold", "bold");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.italic", "italics");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.underline", "underline");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignLeft", "alignment", new Integer(64));
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignCenter", "alignment", new Integer(2));
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignRight", "alignment", new Integer(128));
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.ltr", "orientation", new Integer(0x2000000));
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.rtl", "orientation", new Integer(0x4000000));
        registry.registerAction((IAction)action);
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalTextViewer viewer = new GraphicalTextViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.createOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.examples.text.actions.StyleService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.styleService;
        }
        return super.getAdapter(type);
    }

    private IContentOutlinePage createOutlinePage() {
        return new TextOutlinePage(null);
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setEditPartFactory(new EditPartFactory(){

            public EditPart createEditPart(EditPart context, Object model) {
                if (model instanceof Container) {
                    switch (((Container)model).getType()) {
                        case 5: {
                            return new DocumentPart(model);
                        }
                        case 3: {
                            return new ImportsPart(model);
                        }
                        case 2: 
                        case 4: {
                            return new BlockTextualPart(model);
                        }
                        case 6: {
                            return new InlineTextualPart(model);
                        }
                    }
                    throw new RuntimeException("unknown model type");
                }
                if (model instanceof TextRun) {
                    switch (((TextRun)model).getType()) {
                        case 1: {
                            return new ImportPart(model);
                        }
                    }
                    return new TextFlowPart(model);
                }
                throw new RuntimeException("unexpected model object");
            }
        });
        this.getGraphicalViewer().setContents((Object)this.doc);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream objStream = new ObjectOutputStream(outputStream);
            objStream.writeObject(this.doc);
            objStream.close();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, false, monitor);
            outputStream.close();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getCommandStack().addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                TextCommand command = (TextCommand)event.getCommand();
                if (command != null) {
                    GraphicalTextViewer textViewer = (GraphicalTextViewer)TextEditor.this.getGraphicalViewer();
                    if (event.getDetail() == 8) {
                        textViewer.setSelectionRange(command.getExecuteSelectionRange(textViewer));
                    } else if (event.getDetail() == 16) {
                        textViewer.setSelectionRange(command.getRedoSelectionRange(textViewer));
                    } else if (event.getDetail() == 32) {
                        textViewer.setSelectionRange(command.getUndoSelectionRange(textViewer));
                    }
                }
            }
        });
        super.init(site, input);
        site.getKeyBindingService().setScopes(new String[]{"org.eclipse.gef.textContext"});
        site.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        site.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            InputStream is = file.getContents(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.doc = (Container)ois.readObject();
            ois.close();
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.doc == null) {
            this.doc = new Block(5);
            Block preface = new Block(4);
            preface.add(new TextRun("package foo.bar;"));
            this.doc.add(preface);
            Block imports = new Block(3);
            this.doc.add(imports);
            imports.add(new TextRun("org.eclipse.gef", 1));
            imports.add(new TextRun("org.eclipse.draw2d", 1));
            Block block = new Block(2);
            block.add(new TextRun("Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html\r\nContributors: IBM Corporation - initial API and implementation"));
            this.doc.add(block);
            Block code = new Block(4);
            code.getStyle().setFontFamily("Courier New");
            this.doc.add(code);
            code.add(new TextRun("public void countToANumber(int limit) {\n    for (int i = 0; i < limit; i++)\n        System.out.println(\"Counting: \" + i); //$NON-NLS-1$\n\n}", 5));
        }
        this.setPartName(file.getName());
    }

    class TextOutlinePage
    extends ContentOutlinePage {
        public TextOutlinePage(EditPartViewer viewer) {
            super((EditPartViewer)new TreeViewer());
            TextEditor.this.getEditDomain().addViewer(this.getViewer());
            this.getViewer().setEditPartFactory(new EditPartFactory(this){
                final /* synthetic */ TextOutlinePage this$1;
                {
                    this.this$1 = textOutlinePage;
                }

                public EditPart createEditPart(EditPart context, Object model) {
                    if (model instanceof Container) {
                        return new ContainerTreePart(model);
                    }
                    return new TextRunTreePart(model);
                }
            });
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setContents((Object)TextEditor.this.doc);
        }
    }
}

