/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontCache {
    private static Hashtable table = new Hashtable();

    private FontCache() {
    }

    public static void checkIn(Font font) {
        Value value;
        FontData fd = font.getFontData()[0];
        Key key = new Key(fd.getName(), fd.getHeight(), (fd.getStyle() & 1) != 0, (fd.getStyle() & 2) != 0);
        Value value2 = value = (Value)table.get(key);
        value2.refCount = value2.refCount - 1;
        if (value.refCount == 0) {
            table.remove(key);
            value.font.dispose();
        }
    }

    public static Font checkOut(String fontName, int fontHeight, boolean isBold, boolean isItalic) {
        Key key = new Key(fontName, fontHeight, isBold, isItalic);
        Value value = (Value)table.get(key);
        if (value == null) {
            value = new Value();
            int style = (isBold ? 1 : 0) | (isItalic ? 2 : 0);
            value.font = new Font(null, new FontData(fontName, fontHeight, style));
            table.put(key, value);
        }
        Value value2 = value;
        value2.refCount = value2.refCount + 1;
        return value.font;
    }

    private static class Key {
        private String fontName;
        private int height;
        private boolean isBold;
        private boolean isItalic;

        Key(String fontName, int height, boolean isBold, boolean isItalic) {
            this.fontName = fontName;
            this.height = height;
            this.isBold = isBold;
            this.isItalic = isItalic;
        }

        public boolean equals(Object obj) {
            boolean result;
            boolean bl = result = obj == this;
            if (!result && obj instanceof Key) {
                Key key = (Key)obj;
                result = this.fontName.equalsIgnoreCase(key.fontName) && this.height == key.height && this.isBold == key.isBold && this.isItalic == key.isItalic;
            }
            return result;
        }

        public int hashCode() {
            return this.fontName.toLowerCase().hashCode() + this.height;
        }
    }

    private static class Value {
        private Font font;
        private int refCount;

        Value() {
        }
    }
}

