/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.beans.PropertyChangeEvent;
import java.text.BreakIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.AbstractTextualPart;
import org.eclipse.gef.examples.text.edit.CaretSearch;
import org.eclipse.gef.examples.text.edit.FontCache;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Font;

public class TextFlowPart
extends AbstractTextualPart {
    private Font localFont;

    public TextFlowPart(Object model) {
        this.setModel(model);
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        TextFlow flow = new TextFlow();
        if (((TextRun)this.getModel()).getType() == 5) {
            flow.setLayoutManager((LayoutManager)new SimpleTextLayout(flow));
        }
        return flow;
    }

    public void deactivate() {
        super.deactivate();
        if (this.localFont != null) {
            FontCache.checkIn(this.localFont);
        }
    }

    public CaretInfo getCaretPlacement(int offset, boolean trailing) {
        Assert.isTrue((offset <= this.getLength() ? 1 : 0) != 0);
        return this.getTextFlow().getCaretPlacement(offset, trailing);
    }

    public int getLength() {
        return this.getTextFlow().getText().length();
    }

    public TextLocation getLocation(Point absolute, int[] trailing) {
        Point pt = absolute.getCopy();
        this.getTextFlow().translateToRelative((Translatable)pt);
        int offset = this.getTextFlow().getOffset(pt, trailing, null);
        if (offset == -1) {
            offset = this.getTextFlow().getText().length();
        }
        return new TextLocation(this, offset);
    }

    public TextLocation getNextLocation(CaretSearch search) {
        Point where = new Point();
        switch (search.type) {
            case 4: {
                if (!search.isRecursive) break;
                where.y = search.baseline;
                this.getTextFlow().translateToRelative((Translatable)where);
                int offset = search.isForward ? this.getTextFlow().getLastOffsetForLine(where.y) : this.getTextFlow().getFirstOffsetForLine(where.y);
                if (offset == -1) {
                    return null;
                }
                return new TextLocation(this, offset);
            }
            case 1: {
                TextFlow flow = this.getTextFlow();
                if (search.isRecursive) {
                    if (search.isInto) {
                        if (search.isForward) {
                            return new TextLocation(this, flow.getNextVisibleOffset(-1));
                        }
                        return new TextLocation(this, flow.getPreviousVisibleOffset(-1));
                    }
                    if (this.getLength() > 0) {
                        if (search.isForward) {
                            return new TextLocation(this, flow.getNextVisibleOffset(0));
                        }
                        return new TextLocation(this, flow.getPreviousVisibleOffset(flow.getPreviousVisibleOffset(-1)));
                    }
                    return null;
                }
                if (search.isForward && search.where.offset < this.getLength()) {
                    return new TextLocation(this, flow.getNextVisibleOffset(search.where.offset));
                }
                if (search.isForward || search.where.offset <= 0) break;
                return new TextLocation(this, flow.getPreviousVisibleOffset(search.where.offset));
            }
            case 2: {
                if (!search.isRecursive) break;
                where.x = search.x;
                where.y = search.baseline;
                this.getTextFlow().translateToRelative((Translatable)where);
                int[] trailing = new int[1];
                int offset = this.getTextFlow().getNextOffset(where, search.isForward, trailing);
                if (offset == -1) {
                    return null;
                }
                return new TextLocation(this, offset + trailing[0]);
            }
            case 3: {
                int referenceOffset;
                String text = this.getTextFlow().getText();
                int length = text.length();
                int n = referenceOffset = search.where == null ? 0 : search.where.offset;
                if (referenceOffset <= length) {
                    int offset;
                    BreakIterator iter = BreakIterator.getWordInstance();
                    iter.setText(text);
                    if (search.isForward) {
                        offset = referenceOffset < length ? iter.following(referenceOffset) : -1;
                    } else if (referenceOffset == text.length()) {
                        iter.last();
                        offset = iter.previous();
                    } else {
                        offset = iter.preceding(referenceOffset);
                    }
                    if (offset != -1) {
                        return new TextLocation(this, offset);
                    }
                }
                if (search.isRecursive) {
                    return null;
                }
                return this.getTextParent().getNextLocation(search);
            }
        }
        return ((TextualEditPart)this.getParent()).getNextLocation(search);
    }

    TextFlow getTextFlow() {
        return (TextFlow)this.getFigure();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("text")) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        TextRun textRun = (TextRun)this.getModel();
        Style style = textRun.getContainer().getStyle();
        Font font = FontCache.checkOut(style.getFontFamily(), style.getFontHeight(), style.isBold(), style.isItalic());
        if (font != this.localFont) {
            if (this.localFont != null) {
                FontCache.checkIn(this.localFont);
            }
            this.localFont = font;
            this.getFigure().setFont(font);
        } else {
            FontCache.checkIn(font);
        }
        this.getTextFlow().setText(textRun.getText());
    }

    public void setSelection(int start, int end) {
        if (start == end) {
            this.getTextFlow().setSelection(-1, -1);
        } else {
            this.getTextFlow().setSelection(start, end);
        }
    }
}

