/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.examples.ediagram.edit.parts.LabelCellEditorLocator;
import org.eclipse.gef.examples.ediagram.edit.parts.LabelDirectEditManager;
import org.eclipse.gef.examples.ediagram.edit.policies.LabelSelectionEditPolicy;
import org.eclipse.gef.examples.ediagram.figures.SelectableLabel;
import org.eclipse.gef.examples.ediagram.model.commands.DeleteCommand;
import org.eclipse.gef.examples.ediagram.model.properties.PropertySourceFactory;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;

public abstract class BaseEditPart
extends AbstractGraphicalEditPart {
    protected DirectEditManager manager;
    protected Adapter modelListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() != 9 && msg.getEventType() != 8) {
                BaseEditPart.this.handlePropertyChanged(msg);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public BaseEditPart(EObject obj) {
        this.setModel(obj);
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.modelListener);
    }

    protected abstract DirectEditPolicy createDirectEditPolicy();

    public boolean canDeleteFromDiagram() {
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                Boolean bool = (Boolean)deleteRequest.getExtendedData().get(DeleteCommand.KEY_DELETE_FROM_ECORE);
                boolean permDelete = bool == null ? false : bool;
                DeleteCommand cmd = null;
                if (permDelete || BaseEditPart.this.canDeleteFromDiagram()) {
                    cmd = new DeleteCommand(permDelete);
                    cmd.setPartToBeDeleted(this.getHost().getModel());
                }
                return cmd;
            }
        });
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.createDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new LabelSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        SelectableLabel fig = new SelectableLabel();
        fig.setBorder((Border)new MarginBorder(0, 1, 0, 0));
        return fig;
    }

    public void deactivate() {
        ((EObject)this.getModel()).eAdapters().remove((Object)this.modelListener);
        super.deactivate();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == key) {
            return PropertySourceFactory.getPropertySource(this.getModel());
        }
        return super.getAdapter(key);
    }

    IFigure getDirectEditFigure() {
        return this.getFigure();
    }

    String getDirectEditText() {
        IFigure fig = this.getDirectEditFigure();
        if (fig instanceof Label) {
            return ((Label)fig).getText();
        }
        if (fig instanceof TextFlow) {
            return ((TextFlow)fig).getText();
        }
        return "";
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    protected abstract void handlePropertyChanged(Notification var1);

    protected void performDirectEdit() {
        if (this.manager == null) {
            this.manager = new LabelDirectEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this.getDirectEditFigure()));
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }
}

