/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.edit.parts;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.examples.ediagram.edit.parts.AttributeEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.ClassEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.CompartmentEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.DataTypeEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.DiagramEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.EnumEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.EnumLiteralEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.InheritanceLinkEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.JavaClassEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.LinkEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.OperationEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.PackageEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.ReferenceLinkEditPart;
import org.eclipse.gef.examples.ediagram.edit.parts.StickyNoteEditPart;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;
import org.eclipse.gef.examples.ediagram.model.StickyNote;

public class EDiagramPartFactory
implements EditPartFactory {
    private static EDiagramPartFactory FACTORY;

    public static final EDiagramPartFactory getInstance() {
        if (FACTORY == null) {
            FACTORY = new EDiagramPartFactory();
        }
        return FACTORY;
    }

    private EDiagramPartFactory() {
    }

    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof Diagram) {
            return new DiagramEditPart((Diagram)model);
        }
        if (model instanceof StickyNote) {
            return new StickyNoteEditPart((StickyNote)model);
        }
        if (model instanceof NamedElementView) {
            NamedElementView mdl = (NamedElementView)model;
            ENamedElement element = mdl.getENamedElement();
            if (element instanceof EClass) {
                return new ClassEditPart(mdl);
            }
            if (element instanceof EEnum) {
                return new EnumEditPart(mdl);
            }
            if (element instanceof EDataType) {
                return new DataTypeEditPart(mdl);
            }
            if (element instanceof EPackage) {
                return new PackageEditPart(mdl);
            }
        } else {
            if (model instanceof ReferenceView) {
                return new ReferenceLinkEditPart((ReferenceView)model);
            }
            if (model instanceof EOperation) {
                return new OperationEditPart((EOperation)model);
            }
            if (model instanceof EAttribute) {
                return new AttributeEditPart((EAttribute)model);
            }
            if (model instanceof ClassEditPart.PlaceHolderModel || model instanceof List) {
                return new CompartmentEditPart(model);
            }
            if (model instanceof EEnumLiteral) {
                return new EnumLiteralEditPart((EEnumLiteral)model);
            }
            if (model instanceof InheritanceView) {
                return new InheritanceLinkEditPart((InheritanceView)model);
            }
            if (model instanceof Link) {
                return new LinkEditPart((Link)model);
            }
            if (model instanceof String) {
                return new JavaClassEditPart(model);
            }
        }
        return null;
    }
}

