/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.examples.ediagram.edit.parts.BaseEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;

public class LabelDirectEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private double cachedZoom;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private Font scaledFont;
    private ZoomListener zoomListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public LabelDirectEditManager(GraphicalEditPart source, CellEditorLocator locator) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(source, (Class)clazz, locator);
        this.cachedZoom = -1.0;
        this.zoomListener = new ZoomListener(){

            public void zoomChanged(double newZoom) {
                LabelDirectEditManager.this.updateScaledFont(newZoom);
            }
        };
    }

    protected void bringDown() {
        EditPartViewer editPartViewer = this.getEditPart().getViewer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ZoomManager zoomMgr = (ZoomManager)editPartViewer.getProperty(clazz.toString());
        zoomMgr.removeZoomListener(this.zoomListener);
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        super.bringDown();
        this.disposeScaledFont();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 66);
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }

    protected IFigure getDirectEditFigure() {
        return ((BaseEditPart)this.getEditPart()).getDirectEditFigure();
    }

    protected String getInitialText() {
        return ((BaseEditPart)this.getEditPart()).getDirectEditText();
    }

    protected void initCellEditor() {
        this.getCellEditor().setValue((Object)this.getInitialText());
        EditPartViewer editPartViewer = this.getEditPart().getViewer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ZoomManager zoomMgr = (ZoomManager)editPartViewer.getProperty(clazz.toString());
        this.cachedZoom = -1.0;
        this.updateScaledFont(zoomMgr.getZoom());
        zoomMgr.addZoomListener(this.zoomListener);
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void updateScaledFont(double zoom) {
        if (this.cachedZoom == zoom) {
            return;
        }
        Text text = (Text)this.getCellEditor().getControl();
        Font font = this.getEditPart().getFigure().getFont();
        this.disposeScaledFont();
        this.cachedZoom = zoom;
        if (zoom == 1.0) {
            text.setFont(font);
        } else {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.scaledFont = new Font(null, fd);
            text.setFont(this.scaledFont);
        }
    }
}

