/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.examples.ediagram.edit.parts.LinkEditPart;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;

public class ReferenceLinkEditPart
extends LinkEditPart {
    private Label srcCount;
    private Label srcName;
    private Label targetCount;
    private Label targetName;
    private ConnectionEndpointLocator srcCountLocator;
    private ConnectionEndpointLocator srcNameLocator;
    private ConnectionEndpointLocator targetCountLocator;
    private ConnectionEndpointLocator targetNameLocator;
    private RotatableDecoration srcDecor;
    private RotatableDecoration targetDecor;
    private EReference opposite;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ReferenceLinkEditPart(ReferenceView model) {
        super(model);
    }

    public void activate() {
        super.activate();
        this.getEReference().eAdapters().add((Object)this.modelListener);
        this.updateEOpposite(this.getEReference().getEOpposite());
    }

    private String createCountString(EReference ref) {
        int upper;
        int lower = ref.getLowerBound();
        if (lower == (upper = ref.getUpperBound())) {
            return "" + lower;
        }
        return String.valueOf(lower) + ".." + (upper == -1 ? "n" : "" + upper);
    }

    protected IFigure createFigure() {
        PolylineConnection conn = new PolylineConnection();
        this.srcCountLocator = new ConnectionEndpointLocator((Connection)conn, false);
        this.srcNameLocator = new ConnectionEndpointLocator((Connection)conn, false);
        this.srcNameLocator.setVDistance(-4);
        this.targetCountLocator = new ConnectionEndpointLocator((Connection)conn, true);
        this.targetNameLocator = new ConnectionEndpointLocator((Connection)conn, true);
        this.targetCountLocator.setVDistance(-4);
        return conn;
    }

    private PolygonDecoration createPolygonDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-1, 1);
        decorationPointList.addPoint(-2, 0);
        decorationPointList.addPoint(-1, -1);
        decoration.setTemplate(decorationPointList);
        return decoration;
    }

    private PolylineDecoration createPolylineDecoration() {
        PolylineDecoration decoration = new PolylineDecoration();
        decoration.setScale(10.0, 5.0);
        return decoration;
    }

    public void deactivate() {
        this.updateEOpposite(null);
        this.getEReference().eAdapters().remove((Object)this.modelListener);
        super.deactivate();
    }

    private PolylineConnection getConnection() {
        return (PolylineConnection)this.getFigure();
    }

    protected EReference getEReference() {
        return this.getRefView().getEReference();
    }

    protected ReferenceView getRefView() {
        return (ReferenceView)this.getModel();
    }

    protected void handlePropertyChanged(Notification msg) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.examples.ediagram.model.ReferenceView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (msg.getFeatureID((Class)clazz)) {
            case 4: {
                this.refreshVisuals();
                return;
            }
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.emf.ecore.EReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (msg.getFeatureID((Class)clazz2)) {
            case 1: {
                this.updateSourceName();
                this.updateTargetName();
                return;
            }
            case 4: 
            case 5: 
            case 6: {
                this.updateSourceCount();
                this.updateTargetCount();
                return;
            }
            case 20: {
                this.updateEOpposite(this.getEReference().getEOpposite());
            }
            case 17: 
            case 18: {
                this.refreshVisuals();
                return;
            }
        }
        super.handlePropertyChanged(msg);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateSourceDecoration();
        this.updateTargetDecoration();
        this.updateSourceCount();
        this.updateSourceName();
        this.updateTargetCount();
        this.updateTargetName();
    }

    private void updateEOpposite(EReference opp) {
        if (this.opposite == opp) {
            return;
        }
        if (this.opposite != null) {
            this.opposite.eAdapters().remove((Object)this.modelListener);
        }
        this.opposite = opp;
        if (this.opposite != null) {
            this.opposite.eAdapters().add((Object)this.modelListener);
        }
    }

    private void updateSourceCount() {
        if (this.getRefView().isOppositeShown() && this.getEReference().getEOpposite() != null) {
            if (this.getEReference().isContainment()) {
                if (this.srcCount != null) {
                    this.getConnection().remove((IFigure)this.srcCount);
                    this.srcCount = null;
                }
            } else {
                if (this.srcCount == null) {
                    this.srcCount = new Label();
                    this.srcCount.setOpaque(true);
                    this.getConnection().add((IFigure)this.srcCount, (Object)this.srcCountLocator);
                }
                this.srcCount.setText(this.createCountString(this.getEReference().getEOpposite()));
            }
        } else if (this.srcCount != null) {
            this.getConnection().remove((IFigure)this.srcCount);
            this.srcCount = null;
        }
    }

    private void updateSourceDecoration() {
        if (this.getEReference().isContainment()) {
            if (this.srcDecor == null) {
                this.srcDecor = this.createPolygonDecoration();
                this.getConnection().setSourceDecoration(this.srcDecor);
            }
        } else if (this.srcDecor != null) {
            this.srcDecor = null;
            this.getConnection().setSourceDecoration(this.srcDecor);
        }
    }

    private void updateSourceName() {
        if (this.getRefView().isOppositeShown() && this.getEReference().getEOpposite() != null) {
            if (this.srcName == null) {
                this.srcName = new Label();
                this.srcName.setOpaque(true);
                this.getConnection().add((IFigure)this.srcName, (Object)this.srcNameLocator);
            }
            this.srcName.setText("+" + this.getEReference().getEOpposite().getName());
        } else if (this.srcName != null) {
            this.getConnection().remove((IFigure)this.srcName);
            this.srcName = null;
        }
    }

    private void updateTargetCount() {
        if (this.getEReference().isContainer() && this.getRefView().isOppositeShown() && this.getEReference().getEOpposite() != null) {
            if (this.targetCount != null) {
                this.getConnection().remove((IFigure)this.targetCount);
                this.targetCount = null;
            }
        } else {
            if (this.targetCount == null) {
                this.targetCount = new Label();
                this.targetCount.setOpaque(true);
                this.getConnection().add((IFigure)this.targetCount, (Object)this.targetCountLocator);
            }
            this.targetCount.setText(this.createCountString(this.getEReference()));
        }
    }

    private void updateTargetDecoration() {
        if (this.getRefView().isOppositeShown() && this.getEReference().getEOpposite() != null) {
            if (this.getEReference().isContainer()) {
                if (this.targetDecor != null && !(this.targetDecor instanceof PolygonDecoration)) {
                    this.getConnection().setTargetDecoration(null);
                    this.targetDecor = null;
                }
                if (this.targetDecor == null) {
                    this.targetDecor = this.createPolygonDecoration();
                    this.getConnection().setTargetDecoration(this.targetDecor);
                }
            } else if (this.targetDecor != null) {
                this.targetDecor = null;
                this.getConnection().setTargetDecoration(this.targetDecor);
            }
        } else if (this.targetDecor == null) {
            this.targetDecor = this.createPolylineDecoration();
            this.getConnection().setTargetDecoration(this.targetDecor);
        }
    }

    private void updateTargetName() {
        if (this.targetName == null) {
            this.targetName = new Label();
            this.targetName.setOpaque(true);
            this.getConnection().add((IFigure)this.targetName, (Object)this.targetNameLocator);
        }
        this.targetName.setText("+" + this.getEReference().getName());
    }
}

