/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.examples.ediagram.edit.parts.PackageEditPart;
import org.eclipse.gef.examples.ediagram.figures.PackageFigure;
import org.eclipse.gef.examples.ediagram.figures.SelectableLabel;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;
import org.eclipse.gef.examples.ediagram.model.commands.ChangeBoundsCommand;
import org.eclipse.gef.examples.ediagram.model.commands.CreateNodeCommand;
import org.eclipse.gef.examples.ediagram.model.commands.ShowOppositeCommand;
import org.eclipse.gef.examples.ediagram.model.commands.TransferLinkCommand;
import org.eclipse.gef.examples.ediagram.model.util.Utilities;
import org.eclipse.gef.examples.ediagram.outline.InheritanceModel;
import org.eclipse.gef.requests.CreateRequest;

public class DiagramLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Rectangle bounds = (Rectangle)constraint;
        return new ChangeBoundsCommand((Node)child.getModel(), bounds.getLocation(), bounds.width);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof PackageEditPart) {
            return new NonResizableEditPolicy(){

                private SelectableLabel getSelectableLabel() {
                    return ((PackageFigure)((PackageEditPart)this.getHost()).getFigure()).getLabel();
                }

                protected void hideSelection() {
                    super.hideSelection();
                    this.getSelectableLabel().setSelected(false);
                    this.getSelectableLabel().setFocus(false);
                }

                protected void showSelection() {
                    super.showSelection();
                    this.getSelectableLabel().setSelected(true);
                    this.getSelectableLabel().setFocus(true);
                }
            };
        }
        ResizableEditPolicy childPolicy = new ResizableEditPolicy();
        childPolicy.setResizeDirections(24);
        return childPolicy;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObj = request.getNewObject();
        if (newObj instanceof Node) {
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            return new CreateNodeCommand((Node)newObj, (Diagram)this.getHost().getModel(), constraint.getLocation(), constraint.width);
        }
        if (newObj instanceof List) {
            List views = (List)newObj;
            List businessModels = (List)request.getExtendedData().get("Outline To Diagram Transfer");
            if (!(businessModels.get(businessModels.size() - 1) instanceof ProcessedMarker)) {
                this.processSelection(businessModels, views);
                businessModels.add(new ProcessedMarker());
            }
            if (views.isEmpty()) {
                return UnexecutableCommand.INSTANCE;
            }
            CompoundCommand command = new CompoundCommand("Drag from Outline");
            Point loc = request.getLocation().getCopy();
            this.getHostFigure().translateToRelative((Translatable)loc);
            int i = 0;
            while (i < views.size()) {
                Object view = views.get(i);
                if (view instanceof NamedElementView) {
                    command.add((Command)new CreateNodeCommand((Node)view, (Diagram)this.getHost().getModel(), loc.getTranslated(i * 40, i * 40)));
                } else if (view instanceof LinkInfoHolder) {
                    LinkInfoHolder info = (LinkInfoHolder)view;
                    command.add((Command)new TransferLinkCommand(info.link, info.src, info.target));
                } else if (view instanceof ShowOppositeMarker) {
                    command.add((Command)new ShowOppositeCommand(((ShowOppositeMarker)view).refView));
                }
                ++i;
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }

    private void processSelection(List models, List views) {
        ArrayList newModels = new ArrayList();
        ArrayList<Object> newViews = new ArrayList<Object>();
        int i = 0;
        while (i < models.size()) {
            Object model = models.get(i);
            if (Utilities.findViewFor(model, this.getHost().getModel()) == null) {
                if (model instanceof EReference) {
                    EReference ref = (EReference)model;
                    ReferenceView oppView = (ReferenceView)Utilities.findViewFor(ref.getEOpposite(), this.getHost().getModel());
                    int oppIndex = newModels.indexOf(ref.getEOpposite());
                    if (oppView != null || oppIndex != -1) {
                        newModels.add(model);
                        if (oppView != null) {
                            newViews.add(new ShowOppositeMarker(oppView));
                        } else {
                            newViews.add(new ShowOppositeMarker((ReferenceView)((LinkInfoHolder)newViews.get(oppIndex)).link));
                        }
                    } else {
                        int index;
                        Node srcView = (Node)Utilities.findViewFor(ref.getEContainingClass(), this.getHost().getModel());
                        Node destView = (Node)Utilities.findViewFor(ref.getEReferenceType(), this.getHost().getModel());
                        if (srcView == null) {
                            index = models.indexOf(ref.getEContainingClass());
                            Node node = srcView = index >= 0 ? (Node)views.get(index) : null;
                        }
                        if (destView == null) {
                            index = models.indexOf(ref.getEReferenceType());
                            Node node = destView = index >= 0 ? (Node)views.get(index) : null;
                        }
                        if (srcView != null && destView != null) {
                            ReferenceView refView = (ReferenceView)views.get(i);
                            refView.setEReference(ref);
                            newModels.add(model);
                            newViews.add(new LinkInfoHolder(refView, srcView, destView));
                        }
                    }
                } else if (model instanceof InheritanceModel) {
                    InheritanceModel link = (InheritanceModel)model;
                    Node srcView = (Node)Utilities.findViewFor(link.getSubType(), this.getHost().getModel());
                    Node destView = (Node)Utilities.findViewFor(link.getSuperType(), this.getHost().getModel());
                    if (srcView == null) {
                        int index = models.indexOf(link.getSubType());
                        Node node = srcView = index >= 0 ? (Node)views.get(index) : null;
                    }
                    if (destView == null) {
                        int index = models.indexOf(link.getSuperType());
                        Node node = destView = index >= 0 ? (Node)views.get(index) : null;
                    }
                    if (srcView != null && destView != null) {
                        newModels.add(model);
                        newViews.add(new LinkInfoHolder((Link)views.get(i), srcView, destView));
                    }
                } else if (model instanceof ENamedElement) {
                    NamedElementView classView = (NamedElementView)views.get(i);
                    classView.setENamedElement((ENamedElement)model);
                    newModels.add(0, model);
                    newViews.add(0, classView);
                }
            }
            ++i;
        }
        models.clear();
        views.clear();
        models.addAll(newModels);
        views.addAll(newViews);
    }

    private static class LinkInfoHolder {
        private Link link;
        private Node src;
        private Node target;

        LinkInfoHolder(Link link, Node src, Node target) {
            this.link = link;
            this.src = src;
            this.target = target;
        }
    }

    private static class ShowOppositeMarker {
        private ReferenceView refView;

        ShowOppositeMarker(ReferenceView view) {
            this.refView = view;
        }
    }

    private static class ProcessedMarker {
        ProcessedMarker() {
        }
    }
}

