/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.examples.ediagram.editor.OutlineToDiagramTransfer;
import org.eclipse.gef.examples.ediagram.model.ModelFactory;
import org.eclipse.gef.examples.ediagram.outline.InheritanceModel;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class DiagramDropTargetListener
extends AbstractTransferDropTargetListener {
    private Factory factory;

    public DiagramDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)OutlineToDiagramTransfer.getInstance());
    }

    protected Request createTargetRequest() {
        CreateRequest req = new CreateRequest();
        List transfer = (List)((OutlineToDiagramTransfer)this.getTransfer()).getObject();
        req.getExtendedData().put("Outline To Diagram Transfer", transfer);
        if (this.factory == null) {
            this.factory = new Factory();
        }
        this.factory.setTransferredObjects(transfer);
        req.setFactory((CreationFactory)this.factory);
        return req;
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOver();
    }

    public boolean isEnabled(DropTargetEvent event) {
        boolean result = super.isEnabled(event);
        if (result) {
            this.updateTargetRequest();
            this.updateTargetEditPart();
            Command cmd = this.getCommand();
            result = cmd != null && cmd.canExecute();
        }
        return result;
    }

    protected void updateTargetRequest() {
        CreateRequest req = (CreateRequest)this.getTargetRequest();
        req.setLocation(this.getDropLocation());
    }

    protected static class Factory
    implements CreationFactory {
        private List transfer;
        private List result;

        protected Factory() {
        }

        public Object getNewObject() {
            if (this.result != null) {
                return this.result;
            }
            this.result = new ArrayList();
            Iterator iter = this.transfer.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (element instanceof EReference) {
                    this.result.add(ModelFactory.eINSTANCE.createReferenceView());
                    continue;
                }
                if (element instanceof InheritanceModel) {
                    this.result.add(ModelFactory.eINSTANCE.createInheritanceView());
                    continue;
                }
                this.result.add(ModelFactory.eINSTANCE.createNamedElementView());
            }
            return this.result;
        }

        public Object getObjectType() {
            return null;
        }

        public void setTransferredObjects(List transfer) {
            if (this.transfer != transfer) {
                this.transfer = transfer;
                this.result = null;
            }
        }
    }
}

