/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.examples.ediagram.EDiagramPlugin;
import org.eclipse.gef.examples.ediagram.edit.parts.EDiagramPartFactory;
import org.eclipse.gef.examples.ediagram.editor.DiagramDropTargetListener;
import org.eclipse.gef.examples.ediagram.editor.EDiagramPaletteDropListener;
import org.eclipse.gef.examples.ediagram.editor.EDiagramPaletteFactory;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.commands.DeleteCommand;
import org.eclipse.gef.examples.ediagram.outline.EDiagramOutlinePage;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ToggleSnapToGeometryAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class EDiagramEditor
extends GraphicalEditorWithFlyoutPalette {
    protected static final String PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PALETTE_SIZE = "Palette Size";
    protected static final String PALETTE_STATE = "Palette state";
    private Diagram diagram;
    private PaletteRoot paletteRoot;
    private final ResourceSet rsrcSet = new ResourceSetImpl();
    static /* synthetic */ Class class$0;

    public EDiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)EDiagramPartFactory.getInstance());
        this.getActionRegistry().registerAction((IAction)new ToggleSnapToGeometryAction(viewer));
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(viewer){

            public boolean keyPressed(KeyEvent event) {
                if (event.stateMask == SWT.MOD1 && event.keyCode == 127) {
                    List objects = EDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                    if (objects == null || objects.isEmpty()) {
                        return true;
                    }
                    GroupRequest deleteReq = new GroupRequest((Object)"delete");
                    deleteReq.getExtendedData().put(DeleteCommand.KEY_DELETE_FROM_ECORE, Boolean.TRUE);
                    CompoundCommand compoundCmd = new CompoundCommand("Delete");
                    int i = 0;
                    while (i < objects.size()) {
                        EditPart object = (EditPart)objects.get(i);
                        Command cmd = object.getCommand((Request)deleteReq);
                        if (cmd != null) {
                            compoundCmd.add(cmd);
                        }
                        ++i;
                    }
                    EDiagramEditor.this.getCommandStack().execute((Command)compoundCmd);
                    return true;
                }
                return super.keyPressed(event);
            }
        };
        keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        viewer.setKeyHandler((KeyHandler)keyHandler);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
    }

    protected void createActions() {
        super.createActions();
        DirectEditAction action = new DirectEditAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.setCustomizer(new PaletteCustomizer(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void revertToSaved() {
                    }

                    public void save() {
                    }
                });
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return EDiagramPlugin.getPlugin().getPluginPreferences().getInt(EDiagramEditor.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return EDiagramPlugin.getPlugin().getPluginPreferences().getInt(EDiagramEditor.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return EDiagramPlugin.getPlugin().getPluginPreferences().getInt(EDiagramEditor.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                EDiagramPlugin.getPlugin().getPluginPreferences().setValue(EDiagramEditor.PALETTE_DOCK_LOCATION, location);
                EDiagramPlugin.getPlugin().savePluginPreferences();
            }

            public void setPaletteState(int state) {
                EDiagramPlugin.getPlugin().getPluginPreferences().setValue(EDiagramEditor.PALETTE_STATE, state);
                EDiagramPlugin.getPlugin().savePluginPreferences();
            }

            public void setPaletteWidth(int width) {
                EDiagramPlugin.getPlugin().getPluginPreferences().setValue(EDiagramEditor.PALETTE_SIZE, width);
                EDiagramPlugin.getPlugin().savePluginPreferences();
            }
        };
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new EDiagramOutlinePage(this.diagram, this.getActionRegistry());
        }
        return super.getAdapter(type);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = EDiagramPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    public void doSave(IProgressMonitor monitor) {
        ArrayList<Resource> saveFailed = new ArrayList<Resource>();
        Iterator iter = this.rsrcSet.getResources().iterator();
        while (iter.hasNext()) {
            Resource rsrc = (Resource)iter.next();
            try {
                if (this.isReadOnly(rsrc)) continue;
                rsrc.save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                EDiagramPlugin.INSTANCE.log(e);
                saveFailed.add(rsrc);
            }
        }
        if (saveFailed.isEmpty()) {
            this.getCommandStack().markSaveLocation();
        } else {
            String error = "The following resources could not be saved:\n";
            Iterator iter2 = saveFailed.iterator();
            while (iter2.hasNext()) {
                error = String.valueOf(error) + '\n' + ((Resource)iter2.next()).getURI().toString();
            }
            error = String.valueOf(error) + "\n\nSee the error log for details.";
            MessageDialog dialog = new MessageDialog(this.getGraphicalControl().getShell(), "Errors Detected", null, error, 1, new String[]{"OK"}, 0);
            dialog.open();
        }
    }

    public void doSaveAs() {
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.diagram);
        viewer.addDropTargetListener((TransferDropTargetListener)new DiagramDropTargetListener((EditPartViewer)viewer));
        viewer.addDropTargetListener((TransferDropTargetListener)new EDiagramPaletteDropListener((EditPartViewer)viewer));
    }

    protected boolean isReadOnly(Resource resource) {
        return resource.getURI().toString().startsWith("platform:/plugin/");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource resource = this.rsrcSet.getResource(uri, true);
        this.diagram = (Diagram)resource.getContents().get(0);
        this.setPartName(file.getName());
    }
}

