/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class BentCornerFigure
extends Figure {
    protected static int DEFAULT_CORNER_SIZE = 10;
    private int cornerSize;

    public BentCornerFigure() {
        this.setBackgroundColor(ColorConstants.orange);
        this.setForegroundColor(ColorConstants.black);
        this.setCornerSize(DEFAULT_CORNER_SIZE);
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle rect = this.getBounds().getCopy();
        graphics.translate(this.getLocation());
        PointList outline = new PointList();
        outline.addPoint(0, 0);
        outline.addPoint(rect.width - this.cornerSize, 0);
        outline.addPoint(rect.width - 1, this.cornerSize);
        outline.addPoint(rect.width - 1, rect.height - 1);
        outline.addPoint(0, rect.height - 1);
        graphics.fillPolygon(outline);
        PointList innerLine = new PointList();
        innerLine.addPoint(rect.width - this.cornerSize - 1, 0);
        innerLine.addPoint(rect.width - this.cornerSize - 1, this.cornerSize);
        innerLine.addPoint(rect.width - 1, this.cornerSize);
        innerLine.addPoint(rect.width - this.cornerSize - 1, 0);
        innerLine.addPoint(0, 0);
        innerLine.addPoint(0, rect.height - 1);
        innerLine.addPoint(rect.width - 1, rect.height - 1);
        innerLine.addPoint(rect.width - 1, this.cornerSize);
        graphics.drawPolygon(innerLine);
        graphics.translate(this.getLocation().getNegated());
    }

    public void setCornerSize(int newSize) {
        this.cornerSize = newSize;
    }
}

