/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.ediagram.figures.SelectableLabel;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;

public class PackageFigure
extends Figure
implements HandleBounds {
    private static Color brown = new Color(null, 205, 133, 63);
    private static Color darkBrown = new Color(null, 139, 69, 19);
    private static Color lightBrown = new Color(null, 244, 164, 96);
    protected Box fPackage;
    protected SelectableLabel label;

    public PackageFigure() {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        layout.setMinorAlignment(0);
        layout.setSpacing(2);
        this.setLayoutManager((LayoutManager)layout);
        this.fPackage = new Box();
        this.add((IFigure)this.fPackage);
        this.label = new SelectableLabel();
        this.add((IFigure)this.label);
        this.label.setBorder((Border)new MarginBorder(0, 1, 0, 0));
    }

    public boolean containsPoint(int x, int y) {
        return this.getHandleBounds().contains(x, y) || this.label.containsPoint(x, y);
    }

    public Rectangle getHandleBounds() {
        return this.fPackage.getBounds();
    }

    public SelectableLabel getLabel() {
        return this.label;
    }

    public void setText(String s) {
        this.label.setText(s);
    }

    protected static class Box
    extends Figure {
        public Box() {
            this.setSize(51, 51);
            this.setBackgroundColor(lightBrown);
            this.setForegroundColor(darkBrown);
            this.setOpaque(true);
            this.setBorder((Border)new LineBorder(brown));
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.drawLine(this.bounds.getTop(), this.bounds.getBottom().translate(0, -1));
            graphics.drawLine(this.bounds.getLeft(), this.bounds.getRight().translate(-1, 0));
        }
    }
}

