/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.Node;

public class ChangeBoundsCommand
extends Command {
    private Node node;
    private Point newLocation;
    private Point oldLocation;
    private int newWidth;
    private int oldWidth;

    public ChangeBoundsCommand(Node node, Point newLocation, int newWidth) {
        super("Change Bounds");
        this.setNode(node);
        this.setNewLocation(newLocation);
        this.newWidth = newWidth;
    }

    public boolean canExecute() {
        return this.node != null && this.newLocation != null && (this.newWidth == -1 || this.newWidth > 0);
    }

    public void execute() {
        this.oldLocation = this.node.getLocation();
        this.oldWidth = this.node.getWidth();
        this.redo();
    }

    public void redo() {
        this.node.setLocation(this.newLocation);
        this.node.setWidth(this.newWidth);
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setNewLocation(Point loc) {
        this.newLocation = loc;
    }

    public void undo() {
        this.node.setWidth(this.oldWidth);
        this.node.setLocation(this.oldLocation);
    }
}

