/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.StickyNote;
import org.eclipse.gef.examples.ediagram.model.util.Utilities;

public class CreateNodeCommand
extends Command {
    private int width = -1;
    private Point loc;
    private Node node;
    private Diagram diagram;
    private boolean packageSet;
    private boolean packageAdded;

    public CreateNodeCommand(Node newObject, Diagram parent, Point location) {
        super("Create Node");
        this.node = newObject;
        this.diagram = parent;
        this.loc = location;
    }

    public CreateNodeCommand(Node newObject, Diagram parent, Point location, int width) {
        this(newObject, parent, location);
        this.width = width;
    }

    public boolean canExecute() {
        return this.node != null && this.diagram != null && this.loc != null && (this.width == -1 || this.width > 0);
    }

    public void execute() {
        if (this.node instanceof NamedElementView) {
            NamedElementView view = (NamedElementView)this.node;
            if (view.getENamedElement().getName() == null) {
                view.getENamedElement().setName("DefaultName" + (int)(Math.random() * 1.0E7));
            }
            if (view.getENamedElement() instanceof EClassifier) {
                if (((EClassifier)view.getENamedElement()).getEPackage() == null) {
                    ((EPackage)this.diagram.getImports().get(0)).getEClassifiers().add((Object)view.getENamedElement());
                    this.packageSet = true;
                }
            } else if (view.getENamedElement() instanceof EPackage && !Utilities.importsPackage((EPackage)view.getENamedElement(), this.diagram)) {
                ((EPackage)this.diagram.getImports().get(0)).eResource().getContents().add((Object)view.getENamedElement());
                this.diagram.getImports().add((Object)view.getENamedElement());
                this.packageAdded = true;
            }
        } else if (this.node instanceof StickyNote) {
            ((StickyNote)this.node).setText("Comment");
        }
        this.node.setLocation(this.loc);
        this.node.setWidth(this.width);
        this.node.setDiagram(this.diagram);
    }

    public void undo() {
        this.node.setDiagram(null);
        if (this.node instanceof NamedElementView) {
            NamedElementView view = (NamedElementView)this.node;
            if (this.packageSet) {
                ((EClassifier)view.getENamedElement()).getEPackage().getEClassifiers().remove((Object)view.getENamedElement());
            } else if (this.packageAdded) {
                this.diagram.getImports().remove((Object)view.getENamedElement());
                view.getENamedElement().eResource().getContents().remove((Object)view.getENamedElement());
            }
        }
    }
}

