/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.util.Utilities;

public class DeleteCommand
extends Command {
    private boolean isHardDelete;
    private Command delegate;
    public static final Object KEY_DELETE_FROM_ECORE = new Object();

    public DeleteCommand(boolean hardDelete) {
        super("Delete");
        this.isHardDelete = hardDelete;
    }

    public boolean canExecute() {
        return this.delegate != null && this.delegate.canExecute();
    }

    public void execute() {
        this.delegate.execute();
    }

    public Command setPartToBeDeleted(Object model) {
        if (model instanceof NamedElementView) {
            ENamedElement elem = ((NamedElementView)model).getENamedElement();
            if (elem instanceof EClassifier) {
                this.delegate = new DeleteClassifierCommand(model, this.isHardDelete);
            } else if (elem instanceof EPackage) {
                this.delegate = new DeletePackageCommand(model, this.isHardDelete);
            }
        } else {
            this.delegate = model instanceof Node ? new DeleteNodeCommand(model) : (model instanceof EAttribute ? new DeleteAttributeCommand(model) : (model instanceof EOperation ? new DeleteOperationCommand(model) : (model instanceof EEnumLiteral ? new DeleteEnumLiteralCommand(model) : null)));
        }
        return this;
    }

    public void undo() {
        this.delegate.undo();
    }

    private static class DeleteNodeCommand
    extends Command {
        protected Map incomingConnectionsToSource;
        protected Map outgoingConnectionsToTarget;
        protected Diagram diagram;
        protected Node node;
        protected int index;

        public DeleteNodeCommand(Object node) {
            this.node = (Node)node;
            this.diagram = this.node.getDiagram();
        }

        public void execute() {
            Link link;
            this.index = this.diagram.getContents().indexOf((Object)this.node);
            if (this.index == -1) {
                return;
            }
            this.incomingConnectionsToSource = new HashMap();
            this.outgoingConnectionsToTarget = new HashMap();
            Iterator iter = this.node.getIncomingConnections().iterator();
            while (iter.hasNext()) {
                link = (Link)iter.next();
                this.incomingConnectionsToSource.put(link, link.getSource());
                link.setSource(null);
            }
            iter = this.node.getOutgoingConnections().iterator();
            while (iter.hasNext()) {
                link = (Link)iter.next();
                this.outgoingConnectionsToTarget.put(link, link.getTarget());
                link.setTarget(null);
            }
            this.node.getIncomingConnections().clear();
            this.node.getOutgoingConnections().clear();
            this.diagram.getContents().remove(this.index);
        }

        public void undo() {
            Link link;
            if (this.index == -1) {
                return;
            }
            this.diagram.getContents().add(this.index, (Object)this.node);
            Iterator iter = this.incomingConnectionsToSource.keySet().iterator();
            while (iter.hasNext()) {
                link = (Link)iter.next();
                link.setTarget(this.node);
                link.setSource((Node)this.incomingConnectionsToSource.get(link));
            }
            iter = this.outgoingConnectionsToTarget.keySet().iterator();
            while (iter.hasNext()) {
                link = (Link)iter.next();
                link.setTarget((Node)this.outgoingConnectionsToTarget.get(link));
                link.setSource(this.node);
            }
            this.outgoingConnectionsToTarget = null;
            this.incomingConnectionsToSource = null;
        }
    }

    private static class DeleteAttributeCommand
    extends Command {
        private EAttribute attribute;
        private EClass parent;
        private int index;

        public DeleteAttributeCommand(Object attrib) {
            this.attribute = (EAttribute)attrib;
            this.parent = this.attribute.getEContainingClass();
        }

        public void execute() {
            this.index = this.parent.getEStructuralFeatures().indexOf((Object)this.attribute);
            this.parent.getEStructuralFeatures().remove(this.index);
        }

        public void undo() {
            this.parent.getEStructuralFeatures().add(this.index, (Object)this.attribute);
        }
    }

    private static class DeleteEnumLiteralCommand
    extends Command {
        private EEnumLiteral literal;
        private EEnum parent;
        private int index;

        public DeleteEnumLiteralCommand(Object model) {
            this.literal = (EEnumLiteral)model;
            this.parent = this.literal.getEEnum();
        }

        public void execute() {
            this.index = this.parent.getELiterals().indexOf((Object)this.literal);
            this.parent.getELiterals().remove(this.index);
        }

        public void undo() {
            this.parent.getELiterals().add(this.index, (Object)this.literal);
        }
    }

    private static class DeleteOperationCommand
    extends Command {
        private EOperation operation;
        private EClass container;
        private int index;

        public DeleteOperationCommand(Object oper) {
            this.operation = (EOperation)oper;
            this.container = this.operation.getEContainingClass();
        }

        public void execute() {
            this.index = this.container.getEOperations().indexOf((Object)this.operation);
            this.container.getEOperations().remove(this.index);
        }

        public void undo() {
            this.container.getEOperations().add(this.index, (Object)this.operation);
        }
    }

    private static class DeletePackageCommand
    extends DeleteNodeCommand {
        protected NamedElementView view;
        protected EPackage pckg;
        protected EPackage superPackage;
        protected Resource eResource;
        protected int packageIndex;
        protected int importsIndex;
        protected boolean isHardDelete;
        protected Command chain;

        public DeletePackageCommand(Object namedElementView, boolean isHardDelete) {
            super(namedElementView);
            this.view = (NamedElementView)namedElementView;
            this.isHardDelete = isHardDelete;
            this.pckg = (EPackage)this.view.getENamedElement();
        }

        protected Command createChainCommands() {
            CompoundCommand cmd = null;
            Iterator iter = this.pckg.getESubpackages().iterator();
            while (iter.hasNext()) {
                EPackage subPackage = (EPackage)iter.next();
                NamedElementView packageView = (NamedElementView)Utilities.findViewFor(subPackage, this.diagram);
                if (packageView == null) continue;
                if (cmd == null) {
                    cmd = new CompoundCommand();
                }
                cmd.add((Command)new DeletePackageCommand(packageView, true));
            }
            iter = this.pckg.getEClassifiers().iterator();
            while (iter.hasNext()) {
                NamedElementView classifierView = (NamedElementView)Utilities.findViewFor(iter.next(), this.diagram);
                if (classifierView == null) continue;
                if (cmd == null) {
                    cmd = new CompoundCommand();
                }
                cmd.add((Command)new DeleteClassifierCommand(classifierView, false));
            }
            return cmd;
        }

        public void execute() {
            super.execute();
            if (!this.isHardDelete || this.index == -1) {
                return;
            }
            this.importsIndex = this.diagram.getImports().indexOf((Object)this.pckg);
            if (this.importsIndex != -1) {
                this.diagram.getImports().remove(this.importsIndex);
            }
            this.superPackage = this.pckg.getESuperPackage();
            if (this.superPackage != null) {
                this.packageIndex = this.superPackage.getESubpackages().indexOf((Object)this.pckg);
                this.superPackage.getESubpackages().remove(this.packageIndex);
            } else {
                this.eResource = this.pckg.eResource();
                this.packageIndex = this.eResource.getContents().indexOf((Object)this.pckg);
                this.eResource.getContents().remove(this.packageIndex);
            }
            this.chain = this.createChainCommands();
            if (this.chain != null) {
                this.chain.execute();
            }
        }

        public void undo() {
            if (this.index == -1) {
                return;
            }
            if (this.isHardDelete) {
                if (this.chain != null) {
                    this.chain.undo();
                }
                if (this.superPackage != null) {
                    this.superPackage.getESubpackages().add(this.packageIndex, (Object)this.pckg);
                } else {
                    this.eResource.getContents().add(this.packageIndex, (Object)this.pckg);
                }
                if (this.importsIndex != -1) {
                    this.diagram.getImports().add(this.importsIndex, (Object)this.pckg);
                }
            }
            super.undo();
        }
    }

    private static class DeleteClassifierCommand
    extends DeleteNodeCommand {
        protected NamedElementView view;
        protected EClassifier classifier;
        protected EPackage container;
        protected int classifierIndex;
        protected boolean isHardDelete;

        public DeleteClassifierCommand(Object namedElementView, boolean deletePerm) {
            super(namedElementView);
            this.view = (NamedElementView)namedElementView;
            this.isHardDelete = deletePerm;
            this.classifier = (EClassifier)this.view.getENamedElement();
            this.container = this.classifier.getEPackage();
        }

        public void execute() {
            super.execute();
            if (this.index == -1 || !this.isHardDelete) {
                return;
            }
            this.classifierIndex = this.container.getEClassifiers().indexOf((Object)this.classifier);
            this.container.getEClassifiers().remove(this.classifierIndex);
        }

        public void undo() {
            if (this.index == -1) {
                return;
            }
            super.undo();
            if (!this.isHardDelete) {
                return;
            }
            this.container.getEClassifiers().add(this.classifierIndex, (Object)this.classifier);
        }
    }
}

