/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;

public class DeleteLinkCommand
extends Command {
    private Link link;
    private Node src;
    private Node target;
    private int srcIndex;
    private int targetIndex;
    private int superIndex;
    private int parentIndex;
    private boolean isHardDelete;
    private EClass superClass;
    private EClass subClass;
    private EReference reference;
    private EClass parent;

    public DeleteLinkCommand(Link link, boolean isHardDelete) {
        super("Delete Connection");
        this.link = link;
        this.isHardDelete = isHardDelete;
        this.src = link.getSource();
        this.target = link.getTarget();
    }

    public boolean canExecute() {
        return this.link != null && this.src != null && this.target != null;
    }

    public void execute() {
        if (this.isHardDelete && this.link instanceof InheritanceView) {
            this.subClass = (EClass)((NamedElementView)this.src).getENamedElement();
            this.superClass = (EClass)((NamedElementView)this.target).getENamedElement();
            this.superIndex = this.subClass.getESuperTypes().indexOf((Object)this.superClass);
            if (this.superIndex != -1) {
                this.subClass.getESuperTypes().remove(this.superIndex);
            }
        }
        this.srcIndex = this.src.getOutgoingConnections().indexOf((Object)this.link);
        this.targetIndex = this.target.getIncomingConnections().indexOf((Object)this.link);
        if (this.srcIndex != -1 && this.targetIndex != -1) {
            this.src.getOutgoingConnections().remove(this.srcIndex);
            this.target.getIncomingConnections().remove(this.targetIndex);
        }
        if (this.isHardDelete && this.link instanceof ReferenceView) {
            this.reference = ((ReferenceView)this.link).getEReference();
            this.parent = this.reference.getEContainingClass();
            this.parentIndex = this.parent.getEStructuralFeatures().indexOf((Object)this.reference);
            if (this.parentIndex != -1) {
                this.parent.getEStructuralFeatures().remove(this.parentIndex);
            }
        }
    }

    public void undo() {
        if (this.isHardDelete && this.link instanceof ReferenceView && this.parentIndex != -1) {
            this.parent.getEStructuralFeatures().add(this.parentIndex, (Object)this.reference);
        }
        if (this.srcIndex != -1 && this.targetIndex != -1) {
            this.src.getOutgoingConnections().add(this.srcIndex, (Object)this.link);
            this.target.getIncomingConnections().add(this.targetIndex, (Object)this.link);
        }
        if (this.isHardDelete && this.link instanceof InheritanceView && this.superIndex != -1) {
            this.subClass.getESuperTypes().add(this.superIndex, (Object)this.superClass);
        }
    }
}

