/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;

public class LinkCreationCommand
extends Command {
    private Link link;
    private Node source;
    private Node target;

    public LinkCreationCommand(Link newObj, Node src) {
        super("Link Creation");
        this.link = newObj;
        this.source = src;
    }

    public boolean canExecute() {
        boolean result;
        boolean bl = result = this.source != null && this.target != null && this.link != null;
        if (this.link instanceof InheritanceView) {
            result = result && !((EClass)((NamedElementView)this.source).getENamedElement()).getESuperTypes().contains((Object)((NamedElementView)this.target).getENamedElement());
        }
        return result;
    }

    public void execute() {
        if (this.link instanceof ReferenceView) {
            ReferenceView refView = (ReferenceView)this.link;
            EClass srcClass = (EClass)((NamedElementView)this.source).getENamedElement();
            EClass targetClass = (EClass)((NamedElementView)this.target).getENamedElement();
            if (refView.isOppositeShown() && refView.getEReference().getEOpposite() != null) {
                EReference oppRef = refView.getEReference().getEOpposite();
                oppRef.setEType((EClassifier)srcClass);
                targetClass.getEStructuralFeatures().add((Object)oppRef);
            }
            refView.getEReference().setEType((EClassifier)targetClass);
            srcClass.getEStructuralFeatures().add((Object)refView.getEReference());
        } else if (this.link instanceof InheritanceView) {
            ((EClass)((NamedElementView)this.source).getENamedElement()).getESuperTypes().add((Object)((NamedElementView)this.target).getENamedElement());
        }
        if (this.source == this.target) {
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(-10, 10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(-10, -10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(10, -10)));
        }
        this.link.setSource(this.source);
        this.link.setTarget(this.target);
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public void undo() {
        this.link.setSource(null);
        this.link.setTarget(null);
        if (this.source == this.target) {
            this.link.getBendpoints().clear();
        }
        if (this.link instanceof ReferenceView) {
            ReferenceView refView = (ReferenceView)this.link;
            EClass srcClass = (EClass)((NamedElementView)this.source).getENamedElement();
            EClass targetClass = (EClass)((NamedElementView)this.target).getENamedElement();
            srcClass.getEStructuralFeatures().remove((Object)refView.getEReference());
            refView.getEReference().setEType(null);
            if (refView.isOppositeShown() && refView.getEReference().getEOpposite() != null) {
                EReference oppRef = refView.getEReference().getEOpposite();
                targetClass.getEStructuralFeatures().remove((Object)oppRef);
                oppRef.setEType(null);
            }
        } else if (this.link instanceof InheritanceView) {
            ((EClass)((NamedElementView)this.source).getENamedElement()).getESuperTypes().remove((Object)((NamedElementView)this.target).getENamedElement());
        }
    }
}

