/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;

public class ReconnectLinkCommand
extends Command {
    private boolean isSource;
    private Link link;
    private Node newNode;
    private Node oldNode;
    private int oldIndex;
    private int viewIndex;
    private EReference ref;
    private EClass oldClass;
    private EClass newClass;
    private EClass superClass;

    public ReconnectLinkCommand(Link link, Node newNode, boolean isSource) {
        super("Reconnect Link");
        this.link = link;
        this.newNode = newNode;
        this.isSource = isSource;
    }

    public boolean canExecute() {
        return this.link != null && this.newNode != null;
    }

    public void execute() {
        if (this.link instanceof InheritanceView) {
            this.superClass = (EClass)((NamedElementView)this.link.getTarget()).getENamedElement();
            this.oldClass = (EClass)((NamedElementView)this.link.getSource()).getENamedElement();
            this.newClass = (EClass)((NamedElementView)this.newNode).getENamedElement();
            this.oldIndex = this.oldClass.getESuperTypes().indexOf((Object)this.superClass);
            this.oldClass.getESuperTypes().remove(this.oldIndex);
            if (this.isSource) {
                this.newClass.getESuperTypes().add((Object)this.superClass);
            } else {
                this.oldClass.getESuperTypes().add(this.oldIndex, (Object)this.newClass);
            }
        }
        if (this.isSource) {
            this.oldNode = this.link.getSource();
            this.viewIndex = this.oldNode.getOutgoingConnections().indexOf((Object)this.link);
            this.link.setSource(this.newNode);
        } else {
            this.oldNode = this.link.getTarget();
            this.viewIndex = this.oldNode.getIncomingConnections().indexOf((Object)this.link);
            this.link.setTarget(this.newNode);
        }
        if (this.link instanceof ReferenceView) {
            this.ref = ((ReferenceView)this.link).getEReference();
            this.oldClass = (EClass)((NamedElementView)this.oldNode).getENamedElement();
            this.newClass = (EClass)((NamedElementView)this.newNode).getENamedElement();
            if (this.isSource) {
                this.oldIndex = this.oldClass.getEStructuralFeatures().indexOf((Object)this.ref);
                this.oldClass.getEStructuralFeatures().remove(this.oldIndex);
                this.newClass.getEStructuralFeatures().add((Object)this.ref);
            } else {
                this.ref.setEType((EClassifier)this.newClass);
            }
        }
    }

    public void undo() {
        if (this.link instanceof ReferenceView) {
            if (this.isSource) {
                this.newClass.getEStructuralFeatures().remove((Object)this.ref);
                this.oldClass.getEStructuralFeatures().add(this.oldIndex, (Object)this.ref);
            } else {
                this.ref.setEType((EClassifier)this.oldClass);
            }
        }
        if (this.isSource) {
            this.newNode.getOutgoingConnections().remove((Object)this.link);
            this.oldNode.getOutgoingConnections().add(this.viewIndex, (Object)this.link);
        } else {
            this.newNode.getIncomingConnections().remove((Object)this.link);
            this.oldNode.getIncomingConnections().add(this.viewIndex, (Object)this.link);
        }
        this.oldNode = null;
        if (this.link instanceof InheritanceView) {
            if (this.isSource) {
                this.newClass.getESuperTypes().remove((Object)this.superClass);
            } else {
                this.oldClass.getESuperTypes().remove((Object)this.newClass);
            }
            this.oldClass.getESuperTypes().add(this.oldIndex, (Object)this.superClass);
        }
    }
}

