/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.commands;

import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.Node;

public class TransferLinkCommand
extends Command {
    private Node src;
    private Node target;
    private Link link;

    public TransferLinkCommand(Link link, Node src, Node target) {
        super("Create Link from Outline");
        this.link = link;
        this.src = src;
        this.target = target;
    }

    public boolean canExecute() {
        return this.src != null && this.target != null && this.link != null;
    }

    public void execute() {
        if (this.src == this.target) {
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.src.getLocation().getTranslated(-10, 10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.src.getLocation().getTranslated(-10, -10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.src.getLocation().getTranslated(10, -10)));
        }
        this.link.setTarget(this.target);
        this.link.setSource(this.src);
    }

    public void undo() {
        this.link.setSource(null);
        this.link.setTarget(null);
        if (this.src == this.target) {
            this.link.getBendpoints().clear();
        }
    }
}

