/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.impl;

import java.util.StringTokenizer;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.ModelFactory;
import org.eclipse.gef.examples.ediagram.model.ModelPackage;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;
import org.eclipse.gef.examples.ediagram.model.StickyNote;
import org.eclipse.gef.examples.ediagram.model.impl.DiagramImpl;
import org.eclipse.gef.examples.ediagram.model.impl.InheritanceViewImpl;
import org.eclipse.gef.examples.ediagram.model.impl.LinkImpl;
import org.eclipse.gef.examples.ediagram.model.impl.NamedElementViewImpl;
import org.eclipse.gef.examples.ediagram.model.impl.ReferenceViewImpl;
import org.eclipse.gef.examples.ediagram.model.impl.StickyNoteImpl;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDiagram();
            }
            case 1: {
                return this.createReferenceView();
            }
            case 2: {
                return this.createLink();
            }
            case 3: {
                return this.createNamedElementView();
            }
            case 5: {
                return this.createStickyNote();
            }
            case 6: {
                return this.createInheritanceView();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.createPointFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createDimensionFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createAbsoluteBendpointFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 7: {
                return this.convertPointToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertDimensionToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertAbsoluteBendpointToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Diagram createDiagram() {
        DiagramImpl diagram = new DiagramImpl();
        return diagram;
    }

    public ReferenceView createReferenceView() {
        ReferenceViewImpl referenceView = new ReferenceViewImpl();
        return referenceView;
    }

    public Link createLink() {
        LinkImpl link = new LinkImpl();
        return link;
    }

    public NamedElementView createNamedElementView() {
        NamedElementViewImpl namedElementView = new NamedElementViewImpl();
        return namedElementView;
    }

    public StickyNote createStickyNote() {
        StickyNoteImpl stickyNote = new StickyNoteImpl();
        return stickyNote;
    }

    public InheritanceView createInheritanceView() {
        InheritanceViewImpl inheritanceView = new InheritanceViewImpl();
        return inheritanceView;
    }

    public Point createPointFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null || initialValue.length() == 0) {
            return new Point();
        }
        initialValue = initialValue.trim();
        StringTokenizer tokenizer = new StringTokenizer(initialValue, ",");
        int x = 0;
        int y = 0;
        try {
            x = new Integer(tokenizer.nextToken().trim());
            y = new Integer(tokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        return new Point(x, y);
    }

    public String convertPointToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return "0,0";
        }
        Point p = (Point)instanceValue;
        return String.valueOf(p.x) + "," + p.y;
    }

    public Dimension createDimensionFromString(EDataType eDataType, String initialValue) {
        Point p = this.createPointFromString(null, initialValue);
        return new Dimension(p.x, p.y);
    }

    public String convertDimensionToString(EDataType eDataType, Object instanceValue) {
        Dimension d = (Dimension)instanceValue;
        return this.convertPointToString(null, new Point(d.width, d.height));
    }

    public AbsoluteBendpoint createAbsoluteBendpointFromString(EDataType eDataType, String initialValue) {
        return new AbsoluteBendpoint(this.createPointFromString(null, initialValue));
    }

    public String convertAbsoluteBendpointToString(EDataType eDataType, Object instanceValue) {
        return this.convertPointToString(null, ((Bendpoint)instanceValue).getLocation());
    }

    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

