/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.examples.ediagram.model.properties.AbstractPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class CompoundPropertySource
extends AbstractPropertySource {
    private List sources;

    public CompoundPropertySource() {
    }

    public CompoundPropertySource(IPropertySource one, IPropertySource two, IPropertySource three) {
        this.add(one);
        this.add(two);
        this.add(three);
    }

    public void add(IPropertySource propertySource) {
        if (propertySource instanceof AbstractPropertySource) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(propertySource);
        }
    }

    protected void createPropertyDescriptors(List list) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                propertySource.createPropertyDescriptors(list);
            }
        }
    }

    public Object getPropertyValue(Object id) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                Object result = propertySource.getPropertyValue(id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isPropertyResettable(Object id) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                if (!propertySource.isPropertyResettable(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPropertySet(Object id) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                if (!propertySource.isPropertySet(id)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                propertySource.resetPropertyValue(id);
            }
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.sources != null) {
            Iterator i = this.sources.iterator();
            while (i.hasNext()) {
                AbstractPropertySource propertySource = (AbstractPropertySource)i.next();
                propertySource.setPropertyValue(id, value);
            }
        }
    }
}

