/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gef.examples.ediagram.model.properties.BooleanPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.EClassifierPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;

public class EClassPropertySource
extends EClassifierPropertySource {
    private final PropertyId idAbstract;
    private final PropertyId idInterface;

    public EClassPropertySource(String categoryName, EClass model) {
        super(categoryName, (EClassifier)model);
        this.idAbstract = new PropertyId(categoryName, "Abstract");
        this.idInterface = new PropertyId(categoryName, "Interface");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new BooleanPropertyDescriptor(this.idAbstract));
        list.add(new BooleanPropertyDescriptor(this.idInterface));
    }

    protected EClass getEClass() {
        return (EClass)this.getEClassifier();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idAbstract) {
            return BooleanPropertyDescriptor.fromModel(this.getEClass().isAbstract());
        }
        if (id == this.idInterface) {
            return BooleanPropertyDescriptor.fromModel(this.getEClass().isInterface());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idAbstract || id == this.idInterface;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idAbstract) {
            return true;
        }
        if (id == this.idInterface) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idAbstract) {
            this.getEClass().setAbstract(false);
        } else if (id == this.idInterface) {
            this.getEClass().setInterface(false);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idAbstract) {
            this.getEClass().setAbstract(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idInterface) {
            this.getEClass().setInterface(BooleanPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

