/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.gef.examples.ediagram.model.properties.ReadOnlyPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.StringPropertyDescriptor;

public class EClassifierPropertySource
extends ENamedElementPropertySource {
    private final PropertyId idDefaultValue;
    private final PropertyId idInstanceClassName;
    private final PropertyId idPackage;

    public EClassifierPropertySource(String categoryName, EClassifier model) {
        super(categoryName, (ENamedElement)model);
        this.idDefaultValue = new PropertyId(String.valueOf(categoryName) + " (Read-Only)", "Default Value");
        this.idInstanceClassName = new PropertyId(categoryName, "Instance Class Name");
        this.idPackage = new PropertyId(String.valueOf(categoryName) + " (Read-Only)", "Package");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new ReadOnlyPropertyDescriptor(this.idDefaultValue));
        list.add(new StringPropertyDescriptor(this.idInstanceClassName));
        list.add(new ReadOnlyPropertyDescriptor(this.idPackage));
    }

    protected EClassifier getEClassifier() {
        return (EClassifier)this.getENamedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idDefaultValue) {
            return ReadOnlyPropertyDescriptor.fromModel(this.getEClassifier().getDefaultValue());
        }
        if (id == this.idInstanceClassName) {
            return StringPropertyDescriptor.fromModel(this.getEClassifier().getInstanceClassName());
        }
        if (id == this.idPackage) {
            return ReadOnlyPropertyDescriptor.fromModel(this.getEClassifier().getEPackage().getName());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idInstanceClassName;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idInstanceClassName) {
            return this.getEClassifier().getInstanceClassName() != null;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idInstanceClassName) {
            this.getEClassifier().setInstanceClassName(null);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idInstanceClassName) {
            this.getEClassifier().setInstanceClassName(StringPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

