/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.gef.examples.ediagram.model.properties.BooleanPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.EClassifierPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;

public class EDataTypePropertySource
extends EClassifierPropertySource {
    private final PropertyId idSerializable;

    public EDataTypePropertySource(String categoryName, EDataType model) {
        super(categoryName, (EClassifier)model);
        this.idSerializable = new PropertyId(categoryName, "Serializable");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new BooleanPropertyDescriptor(this.idSerializable));
    }

    protected EDataType getEDataType() {
        return (EDataType)this.getENamedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idSerializable) {
            return BooleanPropertyDescriptor.fromModel(this.getEDataType().isSerializable());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idSerializable;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idSerializable) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idSerializable) {
            this.getEDataType().setSerializable(true);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idSerializable) {
            this.getEDataType().setSerializable(BooleanPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

