/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.IntegerPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;

public class EEnumLiteralPropertySource
extends ENamedElementPropertySource {
    private final PropertyId idValue;

    public EEnumLiteralPropertySource(String categoryName, EEnumLiteral model) {
        super(categoryName, (ENamedElement)model);
        this.idValue = new PropertyId(categoryName, "Value");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new IntegerPropertyDescriptor(this.idValue));
    }

    protected EEnumLiteral getEEnumLiteral() {
        return (EEnumLiteral)this.getENamedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idValue) {
            return IntegerPropertyDescriptor.fromModel(this.getEEnumLiteral().getValue());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idValue;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idValue) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idValue) {
            this.getEEnumLiteral().setValue(0);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idValue) {
            this.getEEnumLiteral().setValue(IntegerPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

