/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.StringMatcher;

public class ENamedElementListSelectionDialog
extends SelectionDialog {
    public static final String ELEMENT_SELECTION_TITLE = " Selector";
    public static final String ELEMENT_SELECTION_LABEL = "Select a type (? - any character, * = any string):";
    public static final String ELEMENT_SELECTION_MATCHING = "Matching types:";
    public static final String ELEMENT_SELECTION_PATH = "In packages:";
    Text pattern;
    Table resourceNames;
    Table folderNames;
    String patternString;
    ResourceSet resourceSet;
    Class typeClass;
    static Collator collator = Collator.getInstance();
    boolean gatherResourcesDynamically = true;
    StringMatcher stringMatcher;
    UpdateFilterThread updateFilterThread;
    UpdateGatherThread updateGatherThread;
    ResourceDescriptor[] descriptors;
    int descriptorsSize;
    ENamedElementLabelProvider labelProvider = new ENamedElementLabelProvider();
    boolean okEnabled = false;

    public ENamedElementListSelectionDialog(Shell parentShell, ResourceSet resourceSet, Class typeClass) {
        super(parentShell);
        this.resourceSet = resourceSet;
        this.typeClass = typeClass;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(String.valueOf(typeClass.getName()) + ELEMENT_SELECTION_TITLE);
    }

    protected String adjustPattern() {
        String text = this.pattern.getText().trim();
        if (text.endsWith("<")) {
            return text.substring(0, text.length() - 1);
        }
        if (!text.equals("") && !text.endsWith("*")) {
            return String.valueOf(text) + "*";
        }
        return text;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    public boolean close() {
        boolean result = super.close();
        this.labelProvider.dispose();
        return result;
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
        this.getButton(0).setEnabled(this.okEnabled);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label l = new Label(dialogArea, 0);
        l.setText(ELEMENT_SELECTION_LABEL);
        GridData data = new GridData(768);
        l.setLayoutData((Object)data);
        this.pattern = new Text(dialogArea, 2052);
        this.pattern.setLayoutData((Object)new GridData(768));
        l = new Label(dialogArea, 0);
        l.setText(ELEMENT_SELECTION_MATCHING);
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.resourceNames = new Table(dialogArea, 2564);
        data = new GridData(1808);
        data.heightHint = 12 * this.resourceNames.getItemHeight();
        this.resourceNames.setLayoutData((Object)data);
        l = new Label(dialogArea, 0);
        l.setText(ELEMENT_SELECTION_PATH);
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.folderNames = new Table(dialogArea, 2820);
        data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 4 * this.folderNames.getItemHeight();
        this.folderNames.setLayoutData((Object)data);
        if (this.gatherResourcesDynamically) {
            this.updateGatherThread = new UpdateGatherThread();
        } else {
            this.updateFilterThread = new UpdateFilterThread();
        }
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ENamedElementListSelectionDialog.this.resourceNames.setFocus();
                }
            }
        });
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ENamedElementListSelectionDialog.this.refresh(false);
            }
        });
        this.resourceNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ENamedElementListSelectionDialog.this.updateFolders((ResourceDescriptor)e.item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ENamedElementListSelectionDialog.this.okPressed();
            }
        });
        this.folderNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ENamedElementListSelectionDialog.this.okPressed();
            }
        });
        ENamedElementListSelectionDialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    private void filterResources(boolean force) {
        int matchLength;
        String oldPattern = force ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!force && this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateFilterThread.stop = true;
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        UpdateFilterThread oldThread = this.updateFilterThread;
        this.updateFilterThread = new UpdateFilterThread();
        if (this.patternString.equals("")) {
            this.updateFilterThread.firstMatch = 0;
            this.updateFilterThread.lastMatch = -1;
            this.updateFilterThread.start();
            return;
        }
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateFilterThread.firstMatch = oldThread.firstMatch;
            this.updateFilterThread.lastMatch = oldThread.lastMatch;
            this.updateFilterThread.start();
            return;
        }
        this.updateFilterThread.firstMatch = 0;
        this.updateFilterThread.lastMatch = this.descriptorsSize - 1;
        this.updateFilterThread.start();
    }

    private int getFirstMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                high = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return high;
        }
        return -1;
    }

    private void gatherResources(boolean force) {
        int matchLength;
        String oldPattern = force ? null : this.patternString;
        this.patternString = this.adjustPattern();
        if (!force && this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateGatherThread.stop = true;
        this.updateGatherThread = new UpdateGatherThread();
        if (this.patternString.equals("")) {
            this.updateGatherThread.start();
            return;
        }
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateGatherThread.refilter = true;
            this.updateGatherThread.firstMatch = 0;
            this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
            this.updateGatherThread.start();
            return;
        }
        final ArrayList resources = new ArrayList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ENamedElementListSelectionDialog.this.getMatchingResources(resources);
                ENamedElement[] resourcesArray = new ENamedElement[resources.size()];
                resources.toArray(resourcesArray);
                ENamedElementListSelectionDialog.this.initDescriptors(resourcesArray);
            }
        });
        this.updateGatherThread.firstMatch = 0;
        this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
        this.updateGatherThread.start();
    }

    private Image getImage(ResourceDescriptor desc) {
        ENamedElement r = (ENamedElement)desc.resources.get(0);
        return this.labelProvider.getImage(r);
    }

    private int getLastMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                low = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return low;
        }
        return -1;
    }

    private void getMatchingResources(ArrayList resources) {
        TreeIterator iterator = this.resourceSet.getAllContents();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!this.typeClass.isAssignableFrom(object.getClass()) || !this.match(((ENamedElement)object).getName())) continue;
            resources.add(object);
        }
    }

    private Image getParentImage(EObject eObject) {
        EObject eContainer = eObject.eContainer();
        return this.labelProvider.getImage(eContainer);
    }

    public String getParentLabel(EObject eObject) {
        EObject eContainer = eObject.eContainer();
        if (!(eContainer instanceof EPackage)) {
            return "";
        }
        String parentLabel = this.getParentLabel(eContainer);
        if ("".equals(parentLabel)) {
            return this.labelProvider.getText(eContainer);
        }
        return String.valueOf(parentLabel) + "." + this.labelProvider.getText(eContainer);
    }

    private void initDescriptors(final ENamedElement[] resources) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ENamedElementListSelectionDialog.this.descriptors = new ResourceDescriptor[resources.length];
                int i = 0;
                while (i < resources.length) {
                    ENamedElement r = resources[i];
                    ResourceDescriptor d = new ResourceDescriptor();
                    d.label = r.getName();
                    d.resources.add(r);
                    ENamedElementListSelectionDialog.this.descriptors[i] = d;
                    ++i;
                }
                Arrays.sort(ENamedElementListSelectionDialog.this.descriptors);
                ENamedElementListSelectionDialog.this.descriptorsSize = ENamedElementListSelectionDialog.this.descriptors.length;
                int index = 0;
                if (ENamedElementListSelectionDialog.this.descriptorsSize < 2) {
                    return;
                }
                ResourceDescriptor current = ENamedElementListSelectionDialog.this.descriptors[index];
                int i2 = 1;
                while (i2 < ENamedElementListSelectionDialog.this.descriptorsSize) {
                    if (current.resources.size() > 1) {
                        current.resourcesSorted = false;
                    }
                    ENamedElementListSelectionDialog.this.descriptors[index + 1] = ENamedElementListSelectionDialog.this.descriptors[i2];
                    current = ENamedElementListSelectionDialog.this.descriptors[++index];
                    ++i2;
                }
                ENamedElementListSelectionDialog.this.descriptorsSize = index + 1;
            }
        });
    }

    private boolean match(String label) {
        if (this.patternString == null || this.patternString.equals("") || this.patternString.equals("*")) {
            return true;
        }
        return this.stringMatcher.match(label);
    }

    protected void okPressed() {
        TableItem[] items = this.folderNames.getSelection();
        if (items.length == 1) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(items[0].getData());
            this.setResult(result);
        }
        super.okPressed();
    }

    protected boolean select(ENamedElement resource) {
        return true;
    }

    protected void refresh(boolean force) {
        if (this.gatherResourcesDynamically) {
            this.gatherResources(force);
        } else {
            this.filterResources(force);
        }
    }

    private void updateFolders(final ResourceDescriptor desc) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!desc.resourcesSorted) {
                    Collections.sort(desc.resources, new Comparator(this){
                        final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = 15.access$0(this.this$1).getParentLabel((EObject)((ENamedElement)o1));
                            String s2 = 15.access$0(this.this$1).getParentLabel((EObject)((ENamedElement)o2));
                            return collator.compare(s1, s2);
                        }
                    });
                    desc.resourcesSorted = true;
                }
                ENamedElementListSelectionDialog.this.folderNames.removeAll();
                int i = 0;
                while (i < desc.resources.size()) {
                    TableItem newItem = new TableItem(ENamedElementListSelectionDialog.this.folderNames, 0);
                    ENamedElement r = (ENamedElement)desc.resources.get(i);
                    newItem.setText(ENamedElementListSelectionDialog.this.getParentLabel((EObject)r));
                    newItem.setImage(ENamedElementListSelectionDialog.this.getParentImage((EObject)r));
                    newItem.setData((Object)r);
                    ++i;
                }
                ENamedElementListSelectionDialog.this.folderNames.setSelection(0);
            }

            static /* synthetic */ ENamedElementListSelectionDialog access$0(15 var0) {
                return var0.ENamedElementListSelectionDialog.this;
            }
        });
    }

    private void updateItem(int index, int itemPos, int itemCount) {
        ResourceDescriptor desc = this.descriptors[index];
        if (itemPos < itemCount) {
            TableItem item = this.resourceNames.getItem(itemPos);
            if (item.getData() != desc) {
                item.setText(desc.label);
                item.setData((Object)desc);
                item.setImage(this.getImage(desc));
                if (itemPos == 0) {
                    this.resourceNames.setSelection(0);
                    this.updateFolders(desc);
                }
            }
        } else {
            TableItem item = new TableItem(this.resourceNames, 0);
            item.setText(desc.label);
            item.setData((Object)desc);
            item.setImage(this.getImage(desc));
            if (itemPos == 0) {
                this.resourceNames.setSelection(0);
                this.updateFolders(desc);
            }
        }
        this.updateOKState(true);
    }

    protected void updateOKState(boolean state) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed() && state != this.okEnabled) {
            okButton.setEnabled(state);
            this.okEnabled = state;
        }
    }

    static /* synthetic */ void access$2(ENamedElementListSelectionDialog eNamedElementListSelectionDialog, int n, int n2, int n3) {
        eNamedElementListSelectionDialog.updateItem(n, n2, n3);
    }

    static class ResourceDescriptor
    implements Comparable {
        String label;
        ArrayList resources = new ArrayList();
        boolean resourcesSorted = true;

        ResourceDescriptor() {
        }

        public int compareTo(Object o) {
            return collator.compare(this.label, ((ResourceDescriptor)o).label);
        }
    }

    class UpdateFilterThread
    extends Thread {
        boolean stop = false;
        int firstMatch = 0;
        int lastMatch;

        UpdateFilterThread() {
            this.lastMatch = ENamedElementListSelectionDialog.this.descriptorsSize - 1;
        }

        public void run() {
            int last;
            Display display = ENamedElementListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(new Runnable(this, disposed, itemCount){
                final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateFilterThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (disposed[0]) {
                return;
            }
            if (ENamedElementListSelectionDialog.this.patternString.indexOf(63) == -1 && ENamedElementListSelectionDialog.this.patternString.endsWith("*") && ENamedElementListSelectionDialog.this.patternString.indexOf(42) == ENamedElementListSelectionDialog.this.patternString.length() - 1) {
                this.firstMatch = ENamedElementListSelectionDialog.this.getFirstMatch();
                if (this.firstMatch == -1) {
                    this.firstMatch = 0;
                    this.lastMatch = -1;
                } else {
                    this.lastMatch = ENamedElementListSelectionDialog.this.getLastMatch();
                }
                last = this.lastMatch;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ENamedElementListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                        final /* synthetic */ UpdateFilterThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateFilterThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ENamedElementListSelectionDialog.access$2(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                last = this.lastMatch;
                boolean setFirstMatch = true;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ENamedElementListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ENamedElementListSelectionDialog.this.match(ENamedElementListSelectionDialog.this.descriptors[index].label)) {
                        if (setFirstMatch) {
                            setFirstMatch = false;
                            this.firstMatch = index;
                        }
                        last = index;
                        display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                            final /* synthetic */ UpdateFilterThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateFilterThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ENamedElementListSelectionDialog.access$2(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            this.lastMatch = last;
            display.syncExec(new Runnable(this, itemCount, itemIndex){
                final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateFilterThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).folderNames.removeAll();
                        UpdateFilterThread.access$0(this.this$1).updateOKState(false);
                    }
                }
            });
        }

        static /* synthetic */ ENamedElementListSelectionDialog access$0(UpdateFilterThread updateFilterThread) {
            return updateFilterThread.ENamedElementListSelectionDialog.this;
        }
    }

    class UpdateGatherThread
    extends Thread {
        boolean stop = false;
        int lastMatch = -1;
        int firstMatch = 0;
        boolean refilter = false;

        UpdateGatherThread() {
        }

        public void run() {
            Display display = ENamedElementListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(new Runnable(this, disposed, itemCount){
                final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateGatherThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (disposed[0]) {
                return;
            }
            if (!this.refilter) {
                int i = 0;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ENamedElementListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                        final /* synthetic */ UpdateGatherThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateGatherThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ENamedElementListSelectionDialog.access$2(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ENamedElementListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ENamedElementListSelectionDialog.this.match(ENamedElementListSelectionDialog.this.descriptors[index].label)) {
                        display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                            final /* synthetic */ UpdateGatherThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateGatherThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ENamedElementListSelectionDialog.access$2(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            display.syncExec(new Runnable(this, itemCount, itemIndex){
                final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateGatherThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).folderNames.removeAll();
                        UpdateGatherThread.access$0(this.this$1).updateOKState(false);
                    }
                }
            });
        }

        static /* synthetic */ ENamedElementListSelectionDialog access$0(UpdateGatherThread updateGatherThread) {
            return updateGatherThread.ENamedElementListSelectionDialog.this;
        }
    }
}

