/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementLabelProvider;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementListSelectionDialog;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ENamedElementPropertyDescriptor
extends PropertyDescriptor {
    private final ResourceSet resourceSet;
    private final Class typeClass;

    public ENamedElementPropertyDescriptor(PropertyId propertyId, Resource resource, Class typeClass) {
        super((Object)propertyId, propertyId.getDisplayName());
        this.setCategory(propertyId.getCategoryName());
        this.typeClass = typeClass;
        this.resourceSet = resource.getResourceSet();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        DialogCellEditor editor = new DialogCellEditor(parent){

            protected Object openDialogBox(Control cellEditorWindow) {
                ENamedElementListSelectionDialog dialog = new ENamedElementListSelectionDialog(cellEditorWindow.getShell(), ENamedElementPropertyDescriptor.this.resourceSet, ENamedElementPropertyDescriptor.this.typeClass);
                dialog.open();
                Object[] results = dialog.getResult();
                return results != null ? results[0] : null;
            }

            protected void updateContents(Object value) {
                Label label = this.getDefaultLabel();
                if (label == null) {
                    return;
                }
                String text = "";
                if (value != null) {
                    text = ENamedElementPropertyDescriptor.this.getLabelProvider().getText(value);
                }
                label.setText(text);
            }
        };
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    public Object fromModel(ENamedElement eNamedElement) {
        return eNamedElement;
    }

    public ILabelProvider getLabelProvider() {
        if (!this.isLabelProviderSet()) {
            this.setLabelProvider((ILabelProvider)new ENamedElementLabelProvider());
        }
        return super.getLabelProvider();
    }

    public ENamedElement toModel(Object object) {
        return (ENamedElement)object;
    }
}

