/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.gef.examples.ediagram.model.properties.StringPropertyDescriptor;

public class EPackagePropertySource
extends ENamedElementPropertySource {
    private final PropertyId idNsPrefix;
    private final PropertyId isNsURI;

    public EPackagePropertySource(String categoryName, EPackage model) {
        super(categoryName, (ENamedElement)model);
        this.idNsPrefix = new PropertyId(categoryName, "Namespace Prefix");
        this.isNsURI = new PropertyId(categoryName, "Namespace URI");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new StringPropertyDescriptor(this.idNsPrefix));
        list.add(new StringPropertyDescriptor(this.isNsURI));
    }

    protected EPackage getEPackage() {
        return (EPackage)this.getENamedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idNsPrefix) {
            return StringPropertyDescriptor.fromModel(this.getEPackage().getNsPrefix());
        }
        if (id == this.isNsURI) {
            return StringPropertyDescriptor.fromModel(this.getEPackage().getNsURI());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idNsPrefix) {
            return true;
        }
        if (id == this.isNsURI) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idNsPrefix) {
            this.getEPackage().setNsPrefix(StringPropertyDescriptor.toModel(value));
        } else if (id == this.isNsURI) {
            this.getEPackage().setNsURI(StringPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

