/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gef.examples.ediagram.model.properties.BooleanPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.ETypedElementPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.gef.examples.ediagram.model.properties.StringPropertyDescriptor;

public class EStructuralFeaturePropertySource
extends ETypedElementPropertySource {
    private final PropertyId idChangeable;
    private final PropertyId idDefaultValueLiteral;
    private final PropertyId idDerived;
    private final PropertyId idTransient;
    private final PropertyId idUnsettable;
    private final PropertyId idVolatile;

    public EStructuralFeaturePropertySource(String categoryName, EStructuralFeature model, Class typeClass) {
        super(categoryName, (ETypedElement)model, typeClass);
        this.idChangeable = new PropertyId(categoryName, "Changeable");
        this.idDefaultValueLiteral = new PropertyId(categoryName, "Default Value Literal");
        this.idDerived = new PropertyId(categoryName, "Derived");
        this.idTransient = new PropertyId(categoryName, "Transient");
        this.idUnsettable = new PropertyId(categoryName, "Unsettable");
        this.idVolatile = new PropertyId(categoryName, "Volatile");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new BooleanPropertyDescriptor(this.idChangeable));
        list.add(new StringPropertyDescriptor(this.idDefaultValueLiteral));
        list.add(new BooleanPropertyDescriptor(this.idDerived));
        list.add(new BooleanPropertyDescriptor(this.idTransient));
        list.add(new BooleanPropertyDescriptor(this.idUnsettable));
        list.add(new BooleanPropertyDescriptor(this.idVolatile));
    }

    protected EStructuralFeature getEStructuralFeature() {
        return (EStructuralFeature)this.getETypedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idChangeable) {
            return BooleanPropertyDescriptor.fromModel(this.getEStructuralFeature().isChangeable());
        }
        if (id == this.idDefaultValueLiteral) {
            return StringPropertyDescriptor.fromModel(this.getEStructuralFeature().getDefaultValueLiteral());
        }
        if (id == this.idDerived) {
            return BooleanPropertyDescriptor.fromModel(this.getEStructuralFeature().isDerived());
        }
        if (id == this.idTransient) {
            return BooleanPropertyDescriptor.fromModel(this.getEStructuralFeature().isTransient());
        }
        if (id == this.idUnsettable) {
            return BooleanPropertyDescriptor.fromModel(this.getEStructuralFeature().isUnsettable());
        }
        if (id == this.idVolatile) {
            return BooleanPropertyDescriptor.fromModel(this.getEStructuralFeature().isVolatile());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idChangeable || id == this.idDerived || id == this.idDefaultValueLiteral || id == this.idTransient || id == this.idUnsettable || id == this.idVolatile;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idChangeable) {
            return true;
        }
        if (id == this.idDefaultValueLiteral) {
            return true;
        }
        if (id == this.idDerived) {
            return true;
        }
        if (id == this.idTransient) {
            return true;
        }
        if (id == this.idUnsettable) {
            return true;
        }
        if (id == this.idVolatile) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idChangeable) {
            this.getEStructuralFeature().setChangeable(false);
        } else if (id == this.idDefaultValueLiteral) {
            this.getEStructuralFeature().setDefaultValueLiteral(null);
        } else if (id == this.idDerived) {
            this.getEStructuralFeature().setDerived(false);
        } else if (id == this.idTransient) {
            this.getEStructuralFeature().setTransient(false);
        } else if (id == this.idUnsettable) {
            this.getEStructuralFeature().setUnsettable(false);
        } else if (id == this.idVolatile) {
            this.getEStructuralFeature().setVolatile(false);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idDerived) {
            this.getEStructuralFeature().setChangeable(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idDefaultValueLiteral) {
            this.getEStructuralFeature().setDefaultValueLiteral(StringPropertyDescriptor.toModel(value));
        } else if (id == this.idDerived) {
            this.getEStructuralFeature().setDerived(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idTransient) {
            this.getEStructuralFeature().setTransient(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idUnsettable) {
            this.getEStructuralFeature().setUnsettable(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idUnsettable) {
            this.getEStructuralFeature().setVolatile(BooleanPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

