/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gef.examples.ediagram.model.properties.BooleanPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.ENamedElementPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.IntegerPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;

public class ETypedElementPropertySource
extends ENamedElementPropertySource {
    private final PropertyId idLowerBound;
    private final PropertyId idOrdered;
    private final PropertyId idType;
    private final PropertyId idUnique;
    private final PropertyId idUpperBound;
    protected final ENamedElementPropertyDescriptor typeDescriptor;

    public ETypedElementPropertySource(String categoryName, ETypedElement model, Class typeClass) {
        super(categoryName, (ENamedElement)model);
        this.idLowerBound = new PropertyId(categoryName, "LowerBound");
        this.idOrdered = new PropertyId(categoryName, "Ordered");
        this.idType = new PropertyId(categoryName, "Type");
        this.idUnique = new PropertyId(categoryName, "Unique");
        this.idUpperBound = new PropertyId(categoryName, "Upper Bound");
        this.typeDescriptor = new ENamedElementPropertyDescriptor(this.idType, model.eResource(), typeClass);
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new IntegerPropertyDescriptor(this.idLowerBound));
        list.add(new BooleanPropertyDescriptor(this.idOrdered));
        list.add(this.typeDescriptor);
        list.add(new BooleanPropertyDescriptor(this.idUnique));
        list.add(new IntegerPropertyDescriptor(this.idUpperBound));
    }

    protected ETypedElement getETypedElement() {
        return (ETypedElement)this.getENamedElement();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idLowerBound) {
            return IntegerPropertyDescriptor.fromModel(this.getETypedElement().getLowerBound());
        }
        if (id == this.idOrdered) {
            return BooleanPropertyDescriptor.fromModel(this.getETypedElement().isOrdered());
        }
        if (id == this.idType) {
            return this.typeDescriptor.fromModel((ENamedElement)this.getETypedElement().getEType());
        }
        if (id == this.idUnique) {
            return BooleanPropertyDescriptor.fromModel(this.getETypedElement().isUnique());
        }
        if (id == this.idUpperBound) {
            return IntegerPropertyDescriptor.fromModel(this.getETypedElement().getUpperBound());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idLowerBound || id == this.idOrdered || id == this.idUnique || id == this.idUpperBound;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idLowerBound) {
            return true;
        }
        if (id == this.idOrdered) {
            return true;
        }
        if (id == this.idType) {
            return true;
        }
        if (id == this.idUnique) {
            return true;
        }
        if (id == this.idUpperBound) {
            return true;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idLowerBound) {
            this.getETypedElement().setLowerBound(0);
        } else if (id == this.idOrdered) {
            this.getETypedElement().setOrdered(false);
        } else if (id == this.idUnique) {
            this.getETypedElement().setUnique(false);
        } else if (id == this.idUpperBound) {
            this.getETypedElement().setUpperBound(1);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idLowerBound) {
            this.getETypedElement().setLowerBound(IntegerPropertyDescriptor.toModel(value));
        } else if (id == this.idOrdered) {
            this.getETypedElement().setOrdered(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idType) {
            this.getETypedElement().setEType((EClassifier)this.typeDescriptor.toModel(value));
        } else if (id == this.idUnique) {
            this.getETypedElement().setUnique(BooleanPropertyDescriptor.toModel(value));
        } else if (id == this.idUpperBound) {
            this.getETypedElement().setUpperBound(IntegerPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

