/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.ediagram.model.Link;
import org.eclipse.gef.examples.ediagram.model.properties.ModelPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.gef.examples.ediagram.model.properties.StringPropertyDescriptor;

public class LinkPropertySource
extends ModelPropertySource {
    private final PropertyId idBendpoints;

    public LinkPropertySource(String categoryName, Object model) {
        super(model);
        this.idBendpoints = new PropertyId(categoryName, "Bendpoints");
    }

    protected void createPropertyDescriptors(List list) {
        list.add(new StringPropertyDescriptor(this.idBendpoints));
    }

    public boolean isPropertyResettable(Object id) {
        return id == this.idBendpoints;
    }

    protected Link getLink() {
        return (Link)this.getModel();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idBendpoints) {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = this.getLink().getBendpoints().iterator();
            while (iter.hasNext()) {
                Point point = ((Bendpoint)iter.next()).getLocation();
                buffer.append(point.x);
                buffer.append(',');
                buffer.append(point.y);
                buffer.append(' ');
            }
            return buffer.toString();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return id == this.idBendpoints && !this.getLink().getBendpoints().isEmpty();
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idBendpoints) {
            this.getLink().getBendpoints().clear();
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idBendpoints) {
            ArrayList<AbsoluteBendpoint> points = new ArrayList<AbsoluteBendpoint>();
            try {
                String[] result = ((String)value).split(" ");
                int i = 0;
                while (i < result.length) {
                    String[] coordinates = result[i].split(",");
                    points.add(new AbsoluteBendpoint(Integer.parseInt(coordinates[0]), Integer.parseInt(coordinates[1])));
                    ++i;
                }
                this.getLink().getBendpoints().clear();
                this.getLink().getBendpoints().addAll(points);
            }
            catch (Exception exception) {}
        }
    }
}

