/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.ediagram.model.Node;
import org.eclipse.gef.examples.ediagram.model.properties.IntegerPropertyDescriptor;
import org.eclipse.gef.examples.ediagram.model.properties.ModelPropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class NodePropertySource
extends ModelPropertySource {
    private final PropertyId idX;
    private final PropertyId idY;
    private final PropertyId idWidth;

    public NodePropertySource(String categoryName, Object model) {
        super(model);
        this.idX = new PropertyId(categoryName, "X");
        this.idY = new PropertyId(categoryName, "Y");
        this.idWidth = new PropertyId(categoryName, "Width");
    }

    protected void createPropertyDescriptors(List list) {
        list.add(new IntegerPropertyDescriptor(this.idX));
        list.add(new IntegerPropertyDescriptor(this.idY));
        IntegerPropertyDescriptor desc = new IntegerPropertyDescriptor(this.idWidth);
        desc.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                try {
                    int val = Integer.parseInt((String)value);
                    if (val == -1 || val > 0) {
                        return null;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return "The width has to be an integer greater than 0 (or -1 for default).";
            }
        });
        list.add(desc);
    }

    protected Node getNode() {
        return (Node)this.getModel();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idX) {
            return IntegerPropertyDescriptor.fromModel(this.getNode().getLocation().x);
        }
        if (id == this.idY) {
            return IntegerPropertyDescriptor.fromModel(this.getNode().getLocation().y);
        }
        if (id == this.idWidth) {
            return IntegerPropertyDescriptor.fromModel(this.getNode().getWidth());
        }
        return null;
    }

    public boolean isPropertyResettable(Object id) {
        return id == this.idWidth;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idWidth) {
            return this.getNode().getWidth() != -1;
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idWidth) {
            this.getNode().setWidth(-1);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idX) {
            Point newLoc = this.getNode().getLocation().getCopy();
            newLoc.x = IntegerPropertyDescriptor.toModel(value);
            this.getNode().setLocation(newLoc);
        } else if (id == this.idY) {
            Point newLoc = this.getNode().getLocation().getCopy();
            newLoc.y = IntegerPropertyDescriptor.toModel(value);
            this.getNode().setLocation(newLoc);
        } else if (id == this.idWidth) {
            this.getNode().setWidth(IntegerPropertyDescriptor.toModel(value));
        }
    }
}

