/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.properties;

import java.util.List;
import org.eclipse.gef.examples.ediagram.model.StickyNote;
import org.eclipse.gef.examples.ediagram.model.properties.NodePropertySource;
import org.eclipse.gef.examples.ediagram.model.properties.PropertyId;
import org.eclipse.gef.examples.ediagram.model.properties.StringPropertyDescriptor;

public class StickyNotePropertySource
extends NodePropertySource {
    private final PropertyId idText;

    public StickyNotePropertySource(String categoryName, StickyNote model) {
        super(categoryName, model);
        this.idText = new PropertyId(categoryName, "Text");
    }

    protected void createPropertyDescriptors(List list) {
        super.createPropertyDescriptors(list);
        list.add(new StringPropertyDescriptor(this.idText));
    }

    protected StickyNote getStickyNote() {
        return (StickyNote)this.getNode();
    }

    public Object getPropertyValue(Object id) {
        if (id == this.idText) {
            return StringPropertyDescriptor.fromModel(this.getStickyNote().getText());
        }
        return super.getPropertyValue(id);
    }

    public boolean isPropertyResettable(Object id) {
        return super.isPropertyResettable(id) || id == this.idText;
    }

    public boolean isPropertySet(Object id) {
        if (id == this.idText) {
            return this.getStickyNote().getText() != null;
        }
        return super.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id == this.idText) {
            this.getStickyNote().setText(null);
        } else {
            super.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id == this.idText) {
            this.getStickyNote().setText(StringPropertyDescriptor.toModel(value));
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

