/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.model.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.InheritanceView;
import org.eclipse.gef.examples.ediagram.model.NamedElementView;
import org.eclipse.gef.examples.ediagram.model.ReferenceView;
import org.eclipse.gef.examples.ediagram.outline.InheritanceModel;

public class Utilities {
    public static Object findViewFor(Object model, Object searchOrigin) {
        if (searchOrigin instanceof Diagram) {
            EList children = ((Diagram)searchOrigin).getContents();
            int i = 0;
            while (i < children.size()) {
                Object result = Utilities.findViewFor(model, children.get(i));
                if (result != null) {
                    return result;
                }
                ++i;
            }
        } else if (searchOrigin instanceof NamedElementView) {
            NamedElementView view = (NamedElementView)searchOrigin;
            if (model instanceof EReference || model instanceof InheritanceModel) {
                EList children = view.getOutgoingConnections();
                int i = 0;
                while (i < children.size()) {
                    Object result = Utilities.findViewFor(model, children.get(i));
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
            } else if (model instanceof ENamedElement && view.getENamedElement() == model) {
                return view;
            }
        } else if (searchOrigin instanceof ReferenceView && model instanceof EReference) {
            ReferenceView refView = (ReferenceView)searchOrigin;
            EReference ref = refView.getEReference();
            if (model == ref || refView.isOppositeShown() && model == ref.getEOpposite()) {
                return refView;
            }
        } else if (searchOrigin instanceof InheritanceView && model instanceof InheritanceModel) {
            InheritanceView iView = (InheritanceView)searchOrigin;
            InheritanceModel iModel = (InheritanceModel)model;
            if (iModel.getSubType() == ((NamedElementView)iView.getSource()).getENamedElement() && iModel.getSuperType() == ((NamedElementView)iView.getTarget()).getENamedElement()) {
                return iView;
            }
        }
        return null;
    }

    public static boolean importsPackage(EPackage pckg, Diagram diagram) {
        if (pckg == null) {
            return false;
        }
        do {
            if (!diagram.getImports().contains((Object)pckg)) continue;
            return true;
        } while ((pckg = pckg.getESuperPackage()) != null);
        return false;
    }
}

