/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.outline;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.examples.ediagram.EDiagramImages;
import org.eclipse.gef.examples.ediagram.editor.OutlineDragSourceListener;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.outline.EDiagramTreePartFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EDiagramOutlinePage
extends Page
implements IContentOutlinePage {
    protected ActionRegistry registry;
    protected TreeViewer viewer;
    protected Diagram model;

    public EDiagramOutlinePage(Diagram diagram, ActionRegistry sharedActions) {
        this.model = diagram;
        this.registry = sharedActions;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void createControl(Composite parent) {
        this.viewer = new TreeViewer();
        this.viewer.createControl(parent);
        this.viewer.setEditDomain(new EditDomain());
        this.viewer.setEditPartFactory((EditPartFactory)EDiagramTreePartFactory.getInstance());
        this.viewer.setContents((Object)this.model);
        this.viewer.addDragSourceListener((TransferDragSourceListener)new OutlineDragSourceListener((EditPartViewer)this.viewer));
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public ISelection getSelection() {
        return null;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars bars = pageSite.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, this.registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, this.registry.getAction((Object)id));
        bars.updateActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        ImageDescriptor img = EDiagramImages.getImageDescriptor("expandall.gif");
        Action action = new Action("Expand All", img){

            public void run() {
                this.expand(((Tree)EDiagramOutlinePage.this.viewer.getControl()).getItems());
            }

            private void expand(TreeItem[] items) {
                int i = 0;
                while (i < items.length) {
                    this.expand(items[i].getItems());
                    items[i].setExpanded(true);
                    ++i;
                }
            }
        };
        action.setToolTipText("Expand All");
        manager.add((IAction)action);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
    }
}

