/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.examples.ediagram.EDiagramPlugin;
import org.eclipse.gef.examples.ediagram.model.Diagram;
import org.eclipse.gef.examples.ediagram.model.ModelFactory;
import org.eclipse.gef.examples.ediagram.wizard.NewEDiagramFilePage;
import org.eclipse.gef.examples.ediagram.wizard.SelectEcoreFilesPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;

public class NewEDiagramWizard
extends Wizard
implements INewWizard {
    private NewEDiagramFilePage filePage;
    private SelectEcoreFilesPage ecorePage;
    private ISelection selection;

    public NewEDiagramWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New EDiagram Wizard");
    }

    public void addPages() {
        this.filePage = new NewEDiagramFilePage(this.selection);
        this.addPage((IWizardPage)this.filePage);
        this.ecorePage = new SelectEcoreFilesPage("EDiagram Wizard");
        this.addPage((IWizardPage)this.ecorePage);
    }

    public boolean performFinish() {
        final String containerName = this.filePage.getContainerName();
        final String fileName = this.filePage.getFileName();
        final String[] ecoreFiles = this.ecorePage.getECoreFileNames();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewEDiagramWizard.this.doFinish(containerName, fileName, ecoreFiles, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, String[] ecoreFiles, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        ResourceSetImpl rsrcSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        Resource rsrc = null;
        if (file.exists()) {
            this.throwCoreException("File \"" + file.getFullPath() + "\" already exists");
        }
        rsrc = rsrcSet.createResource(uri);
        Diagram diagram = ModelFactory.eINSTANCE.createDiagram();
        int i = 0;
        while (i < ecoreFiles.length) {
            String filePath = ecoreFiles[i];
            Resource ecoreResource = null;
            try {
                uri = filePath.startsWith("platform:/plugin") ? URI.createURI((String)filePath) : URI.createPlatformResourceURI((String)filePath);
                ecoreResource = rsrcSet.getResource(uri, true);
            }
            catch (Exception exception) {
                URI fileURI = URI.createFileURI((String)filePath);
                try {
                    ecoreResource = rsrcSet.getResource(fileURI, true);
                }
                catch (Exception exception2) {}
            }
            if (ecoreResource == null) {
                ecoreResource = rsrcSet.createResource(uri);
                EPackage pckg = EcoreFactory.eINSTANCE.createEPackage();
                pckg.setName("changeMe");
                ecoreResource.getContents().add((Object)pckg);
                try {
                    ecoreResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    EDiagramPlugin.INSTANCE.log(ioe);
                }
            }
            EList contents = ecoreResource.getContents();
            int j = 0;
            while (j < contents.size()) {
                diagram.getImports().add(contents.get(j));
                ++j;
            }
            ++i;
        }
        if (diagram.getImports().size() == 0) {
            this.throwCoreException("No valid EPackages could be loaded.  At least one EPackage needs to exist for the .ediagram file to be created.");
        }
        rsrc.getContents().add((Object)diagram);
        try {
            rsrc.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            EDiagramPlugin.INSTANCE.log(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.gef.examples.ediagram", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

