/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.ediagram.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class SelectEcoreFilesPage
extends WizardPage {
    private List list;

    public SelectEcoreFilesPage(String pageName) {
        super(pageName, "Specify ECore Files", null);
        this.setDescription("You can specify existing ecore files, or create new ones.  There must be at least one ecore file specified.");
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        page.setLayout((Layout)layout);
        Label label = new Label(page, 0);
        GridData data = new GridData();
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        label.setText("&ECore files: ");
        this.list = new List(page, 2818);
        data = new GridData(4, 4, true, false);
        data.heightHint = 80;
        this.list.setLayoutData((Object)data);
        Composite buttonBar = new Composite(page, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        buttonBar.setLayout((Layout)rowLayout);
        data = new GridData();
        data.verticalAlignment = 128;
        buttonBar.setLayoutData((Object)data);
        Button create = new Button(buttonBar, 8);
        create.setText("&Create");
        create.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new CreationDialog().open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button browseWorkspace = new Button(buttonBar, 8);
        browseWorkspace.setText("Browse &Workspace");
        browseWorkspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(SelectEcoreFilesPage.this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select .ecore files");
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    int i = 0;
                    while (i < result.length) {
                        String file = ((IResource)result[i]).getFullPath().toString();
                        if (file.toLowerCase().endsWith(".ecore")) {
                            SelectEcoreFilesPage.this.list.add(file);
                        }
                        ++i;
                    }
                    SelectEcoreFilesPage.this.updatePageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button specifyPlugin = new Button(buttonBar, 8);
        specifyPlugin.setText("&Plugin Format");
        specifyPlugin.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(SelectEcoreFilesPage.this.getShell(), "Specify .ecore file", "Here you can specify Ecore files in binary, external plug-ins.  Enter the plugin name and path below.  Use forward slash as path separator.\nNOTE: Changes made to Ecore files loaded in this format cannot be saved.\n\nExample: org.eclipse.emf.ecore/model/Ecore.ecore", null, new IInputValidator(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(String newText) {
                        if (newText != null && newText.trim().length() > 8 && newText.indexOf(":") == -1 && newText.indexOf("\\") == -1 && !newText.startsWith("/") && newText.indexOf("/") != -1 && newText.toLowerCase().endsWith(".ecore")) {
                            return null;
                        }
                        return "Invalid input";
                    }
                });
                if (dialog.open() == 0) {
                    SelectEcoreFilesPage.this.list.add("platform:/plugin/" + dialog.getValue().trim());
                    SelectEcoreFilesPage.this.updatePageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button browseFileSystem = new Button(buttonBar, 8);
        browseFileSystem.setText("Browse File &System");
        browseFileSystem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SelectEcoreFilesPage.this.getShell());
                dialog.setFilterExtensions(new String[]{"*.ecore"});
                String file = dialog.open();
                if (file != null && file.trim().length() > 1) {
                    SelectEcoreFilesPage.this.list.add(file);
                    SelectEcoreFilesPage.this.updatePageStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button remove = new Button(buttonBar, 8);
        remove.setText("&Remove");
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                remove.setEnabled(SelectEcoreFilesPage.this.list.getSelectionCount() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectEcoreFilesPage.this.list.remove(SelectEcoreFilesPage.this.list.getSelectionIndices());
                SelectEcoreFilesPage.this.updatePageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        remove.setEnabled(false);
        this.setControl((Control)page);
    }

    public String[] getECoreFileNames() {
        return this.list == null ? null : this.list.getItems();
    }

    public boolean isPageComplete() {
        return this.list != null && this.list.getItemCount() > 0;
    }

    private void updatePageStatus() {
        this.setPageComplete(this.list.getItemCount() > 0);
    }

    private class CreationDialog
    extends Dialog {
        private ResourceAndContainerGroup fileChooser;

        protected CreationDialog() {
            super(SelectEcoreFilesPage.this.getShell());
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (newShell != null) {
                newShell.setText("Create File");
            }
        }

        protected Control createButtonBar(Composite parent) {
            Control bar = super.createButtonBar(parent);
            this.getButton(0).setEnabled(false);
            return bar;
        }

        protected Control createDialogArea(Composite parent) {
            Composite panel = (Composite)super.createDialogArea(parent);
            this.fileChooser = new ResourceAndContainerGroup(panel, new Listener(this){
                final /* synthetic */ CreationDialog this$1;
                {
                    this.this$1 = creationDialog;
                }

                public void handleEvent(Event event) {
                    CreationDialog.access$0(this.this$1, 0).setEnabled(CreationDialog.access$1(this.this$1).areAllValuesValid());
                }
            }, "&Ecore Filename: ", "file", false);
            return panel;
        }

        protected void okPressed() {
            String filename = this.fileChooser.getResource();
            if (!filename.endsWith(".ecore")) {
                filename = filename.concat(".ecore");
            }
            SelectEcoreFilesPage.this.list.add(String.valueOf(this.fileChooser.getContainerFullPath().toString()) + '/' + filename);
            SelectEcoreFilesPage.this.updatePageStatus();
            super.okPressed();
        }

        static /* synthetic */ Button access$0(CreationDialog creationDialog, int n) {
            return creationDialog.getButton(n);
        }

        static /* synthetic */ ResourceAndContainerGroup access$1(CreationDialog creationDialog) {
            return creationDialog.fileChooser;
        }
    }
}

