/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp;

import java.io.Serializable;

public final class ServiceType
implements Serializable {
    private static final long serialVersionUID = 1652247274399819356L;
    private String type = new String();
    private boolean isService = false;
    private boolean isAbstract = false;
    private String concreteType = new String();
    private String principleType = new String();
    private String abstractType = new String();
    private String namingAuthority = new String();

    public ServiceType(String string) {
        this.type = string;
        if (this.type.startsWith("service:")) {
            this.isService = true;
            int n = 8;
            int n2 = this.type.indexOf(":", n);
            if (n2 != -1) {
                this.isAbstract = true;
                this.principleType = this.type.substring(n, n2);
                this.abstractType = this.type.substring(0, n2);
                this.concreteType = this.type.substring(n2 + 1);
            } else {
                this.isAbstract = false;
                this.principleType = this.type.substring(n);
                this.abstractType = "";
                this.concreteType = "";
            }
            int n3 = this.type.indexOf(".") + 1;
            if (n3 != 0) {
                int n4 = this.type.indexOf(":", n3);
                String string2 = "";
                string2 = n4 == -1 ? this.type.substring(n3) : this.type.substring(n3, n4);
                if ("IANA".equalsIgnoreCase(string2)) {
                    this.namingAuthority = "";
                    this.type = this.type.substring(0, n3 - 1) + this.type.substring(n3 + 4, this.type.length());
                } else {
                    this.namingAuthority = string2;
                }
            } else {
                this.namingAuthority = "";
            }
        }
    }

    public boolean isServiceURL() {
        return this.isService;
    }

    public boolean isAbstractType() {
        return this.isAbstract;
    }

    public boolean isNADefault() {
        return "".equals(this.namingAuthority);
    }

    public String getConcreteTypeName() {
        return this.concreteType;
    }

    public String getPrincipleTypeName() {
        return this.principleType;
    }

    public String getAbstractTypeName() {
        return this.abstractType;
    }

    public String getNamingAuthority() {
        return this.namingAuthority;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServiceType)) {
            return false;
        }
        ServiceType serviceType = (ServiceType)object;
        return this.isService == serviceType.isService && this.isAbstract == serviceType.isAbstract && this.concreteType.equals(serviceType.concreteType) && this.principleType.equals(serviceType.principleType) && this.abstractType.equals(serviceType.abstractType) && this.namingAuthority.equals(serviceType.namingAuthority);
    }

    public boolean matches(Object object) {
        if (!(object instanceof ServiceType)) {
            return false;
        }
        ServiceType serviceType = (ServiceType)object;
        if (!this.isAbstract) {
            return this.equals(serviceType);
        }
        return this.equals(serviceType) || serviceType.toString().equals(this.getAbstractTypeName());
    }

    public String toString() {
        return this.type;
    }

    public int hashCode() {
        int n = 0;
        if (this.concreteType != null) {
            n ^= this.concreteType.hashCode();
        }
        if (this.principleType != null) {
            n ^= this.principleType.hashCode() << 8;
        }
        if (this.abstractType != null) {
            n ^= this.abstractType.hashCode() << 16;
        }
        if (this.namingAuthority != null) {
            n ^= this.namingAuthority.hashCode() << 24;
        }
        return n;
    }
}

