/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.Locator;
import ch.ethz.iks.slp.ServiceLocationEnumeration;
import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AttributeRequest;
import ch.ethz.iks.slp.impl.ReplyMessage;
import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPUtils;
import ch.ethz.iks.slp.impl.ServiceLocationEnumerationImpl;
import ch.ethz.iks.slp.impl.ServiceRequest;
import ch.ethz.iks.slp.impl.ServiceTypeRequest;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class LocatorImpl
implements Locator {
    private Locale locale;

    public LocatorImpl() {
        this.locale = SLPCore.DEFAULT_LOCALE;
    }

    public LocatorImpl(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ServiceLocationEnumeration findServiceTypes(String string, List list) throws ServiceLocationException {
        ServiceTypeRequest serviceTypeRequest = new ServiceTypeRequest(string, list, this.locale);
        return new ServiceLocationEnumerationImpl(this.sendRequest(serviceTypeRequest, list));
    }

    public ServiceLocationEnumeration findServices(ServiceType serviceType, List list, String string) throws ServiceLocationException {
        try {
            ServiceRequest serviceRequest = new ServiceRequest(serviceType, list, string, this.locale);
            return new ServiceLocationEnumerationImpl(this.sendRequest(serviceRequest, list));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceLocationException(20, illegalArgumentException.getMessage() + ": " + string);
        }
    }

    public ServiceLocationEnumeration findAttributes(ServiceURL serviceURL, List list, List list2) throws ServiceLocationException {
        return this.findAttributes(new AttributeRequest(serviceURL, list, list2, this.locale));
    }

    public ServiceLocationEnumeration findAttributes(ServiceType serviceType, List list, List list2) throws ServiceLocationException {
        return this.findAttributes(new AttributeRequest(serviceType, list, list2, this.locale));
    }

    private ServiceLocationEnumeration findAttributes(AttributeRequest attributeRequest) throws ServiceLocationException {
        return new ServiceLocationEnumerationImpl(this.sendRequest(attributeRequest, attributeRequest.scopeList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List sendRequest(RequestMessage requestMessage, List list) throws ServiceLocationException {
        List<String> list2 = list != null ? list : Arrays.asList("default");
        ArrayList arrayList = new ArrayList();
        Iterator<String> iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            string = string.toLowerCase();
            List list3 = (List)SLPCore.dAs.get(string);
            SLPCore.platform.logDebug("DAS FOR SCOPE " + string + ": " + list3);
            if ((list3 == null || list3.isEmpty()) && !SLPCore.noDiscovery) {
                SLPCore.daLookup(Arrays.asList(string));
                Map map = SLPCore.dAs;
                synchronized (map) {
                    try {
                        SLPCore.dAs.wait(SLPCore.CONFIG.getWaitTime() / 4);
                    }
                    catch (InterruptedException interruptedException) {
                        SLPCore.platform.logError(interruptedException.getMessage(), interruptedException);
                        Thread.currentThread().interrupt();
                    }
                }
                list3 = (List)SLPCore.dAs.get(string);
            }
            if (list3 != null && !list3.isEmpty()) {
                try {
                    arrayList.addAll(this.sendRequestToDA(requestMessage, list3));
                }
                catch (ServiceLocationException serviceLocationException) {
                    arrayList.addAll(SLPCore.multicastConvergence(requestMessage));
                }
                continue;
            }
            if (SLPCore.noDiscovery) {
                throw new ServiceLocationException(4, "Scope " + string + " is not supported");
            }
            arrayList.addAll(SLPCore.multicastConvergence(requestMessage));
        }
        return arrayList;
    }

    private List sendRequestToDA(RequestMessage requestMessage, List list) throws ServiceLocationException {
        for (int i = 0; i < list.size(); ++i) {
            ReplyMessage replyMessage = null;
            try {
                requestMessage.address = InetAddress.getByName((String)list.get(i));
                requestMessage.port = 427;
                replyMessage = SLPCore.sendMessage(requestMessage, true);
                if (replyMessage.errorCode != 0) continue;
                return replyMessage.getResult();
            }
            catch (Exception exception) {
                SLPCore.platform.logError(exception.getMessage(), exception.fillInStackTrace());
                Object e = list.get(i);
                SLPUtils.removeValueFromAll(SLPCore.dAs, e);
                SLPCore.dASPIs.remove(e);
            }
        }
        throw new ServiceLocationException(20, "No DA reachable");
    }
}

