/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryCompoundWordTokenFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private Set dictionary;
    private String dictFile;
    private int minWordSize;
    private int minSubwordSize;
    private int maxSubwordSize;
    private boolean onlyLongestMatch;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.dictFile = args.get("dictionary");
        this.minWordSize = this.getInt("minWordSize", 5);
        this.minSubwordSize = this.getInt("minSubwordSize", 2);
        this.maxSubwordSize = this.getInt("maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean("onlyLongestMatch", true);
    }

    @Override
    public void inform(ResourceLoader loader) {
        try {
            List wlist = loader.getLines(this.dictFile);
            this.dictionary = StopFilter.makeStopSet((String[])wlist.toArray(new String[0]), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DictionaryCompoundWordTokenFilter create(TokenStream input) {
        return new DictionaryCompoundWordTokenFilter(input, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

