/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

abstract class CSVLoader {
    static String SEPARATOR = "separator";
    static String FIELDNAMES = "fieldnames";
    static String HEADER = "header";
    static String SKIP = "skip";
    static String SKIPLINES = "skipLines";
    static String MAP = "map";
    static String TRIM = "trim";
    static String EMPTY = "keepEmpty";
    static String SPLIT = "split";
    static String ENCAPSULATOR = "encapsulator";
    static String ESCAPE = "escape";
    static String OVERWRITE = "overwrite";
    private static Pattern colonSplit = Pattern.compile(":");
    private static Pattern commaSplit = Pattern.compile(",");
    final IndexSchema schema;
    final SolrParams params;
    final CSVStrategy strategy;
    final UpdateRequestProcessor processor;
    String[] fieldnames;
    SchemaField[] fields;
    FieldAdder[] adders;
    int skipLines;
    final AddUpdateCommand templateAdd;
    String errHeader = "CSVLoader:";

    CSVLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        String encapsulator;
        this.processor = processor;
        this.params = req.getParams();
        this.schema = req.getSchema();
        this.templateAdd = new AddUpdateCommand();
        this.templateAdd.allowDups = false;
        this.templateAdd.overwriteCommitted = true;
        this.templateAdd.overwritePending = true;
        if (this.params.getBool(OVERWRITE, true)) {
            this.templateAdd.allowDups = false;
            this.templateAdd.overwriteCommitted = true;
            this.templateAdd.overwritePending = true;
        } else {
            this.templateAdd.allowDups = true;
            this.templateAdd.overwriteCommitted = false;
            this.templateAdd.overwritePending = false;
        }
        this.strategy = new CSVStrategy(',', '\"', CSVStrategy.COMMENTS_DISABLED, CSVStrategy.ESCAPE_DISABLED, false, false, false, true);
        String sep = this.params.get(SEPARATOR);
        if (sep != null) {
            if (sep.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid separator:'" + sep + "'");
            }
            this.strategy.setDelimiter(sep.charAt(0));
        }
        if ((encapsulator = this.params.get(ENCAPSULATOR)) != null && encapsulator.length() != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid encapsulator:'" + encapsulator + "'");
        }
        String escape = this.params.get(ESCAPE);
        if (escape != null && escape.length() != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid escape:'" + escape + "'");
        }
        if (encapsulator == null && escape != null) {
            this.strategy.setEncapsulator('\ufffe');
            this.strategy.setEscape(escape.charAt(0));
        } else {
            if (encapsulator != null) {
                this.strategy.setEncapsulator(encapsulator.charAt(0));
            }
            if (escape != null) {
                char ch = escape.charAt(0);
                this.strategy.setEscape(ch);
                if (ch == '\\') {
                    this.strategy.setUnicodeEscapeInterpretation(true);
                }
            }
        }
        String fn = this.params.get(FIELDNAMES);
        this.fieldnames = fn != null ? commaSplit.split(fn, -1) : null;
        Boolean hasHeader = this.params.getBool(HEADER);
        this.skipLines = this.params.getInt(SKIPLINES, 0);
        if (this.fieldnames == null) {
            if (null == hasHeader) {
                hasHeader = true;
            } else if (!hasHeader.booleanValue()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "CSVLoader: must specify fieldnames=<fields>* or header=true");
            }
        } else {
            if (hasHeader != null && hasHeader.booleanValue()) {
                ++this.skipLines;
            }
            this.prepareFields();
        }
    }

    void prepareFields() {
        this.fields = new SchemaField[this.fieldnames.length];
        this.adders = new FieldAdder[this.fieldnames.length];
        String skipStr = this.params.get(SKIP);
        List skipFields = skipStr == null ? null : StrUtils.splitSmart((String)skipStr, (char)',');
        FieldAdder adder = new FieldAdder();
        FieldAdderEmpty adderKeepEmpty = new FieldAdderEmpty();
        for (int i = 0; i < this.fields.length; ++i) {
            String fname = this.fieldnames[i];
            if (fname.length() == 0 || skipFields != null && skipFields.contains(fname)) continue;
            this.fields[i] = this.schema.getField(fname);
            boolean keepEmpty = this.params.getFieldBool(fname, EMPTY, false);
            this.adders[i] = keepEmpty ? adderKeepEmpty : adder;
            String[] fmap = this.params.getFieldParams(fname, MAP);
            if (fmap != null) {
                for (String mapRule : fmap) {
                    String[] mapArgs = colonSplit.split(mapRule, -1);
                    if (mapArgs.length != 2) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Map rules must be of the form 'from:to' ,got '" + mapRule + "'");
                    }
                    this.adders[i] = new FieldMapperSingle(mapArgs[0], mapArgs[1], this.adders[i]);
                }
            }
            if (this.params.getFieldBool(fname, TRIM, false)) {
                this.adders[i] = new FieldTrimmer(this.adders[i]);
            }
            if (!this.params.getFieldBool(fname, SPLIT, false)) continue;
            String sepStr = this.params.getFieldParam(fname, SEPARATOR);
            char fsep = sepStr == null || sepStr.length() == 0 ? (char)',' : (char)sepStr.charAt(0);
            String encStr = this.params.getFieldParam(fname, ENCAPSULATOR);
            char fenc = encStr == null || encStr.length() == 0 ? (char)'\ufffe' : (char)encStr.charAt(0);
            String escStr = this.params.getFieldParam(fname, ESCAPE);
            char fesc = escStr == null || encStr.length() == 0 ? CSVStrategy.ESCAPE_DISABLED : escStr.charAt(0);
            CSVStrategy fstrat = new CSVStrategy(fsep, fenc, CSVStrategy.COMMENTS_DISABLED, fesc, false, false, false, false);
            this.adders[i] = new FieldSplitter(fstrat, this.adders[i]);
        }
    }

    private void input_err(String msg, String[] line, int lineno) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.errHeader + ", line=" + lineno + "," + msg + "\n\tvalues={");
        for (String val : line) {
            sb.append("'" + val + "',");
        }
        sb.append('}');
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, sb.toString());
    }

    void load(Reader input) throws IOException {
        Reader reader = input;
        if (this.skipLines > 0) {
            if (!(reader instanceof BufferedReader)) {
                reader = new BufferedReader(reader);
            }
            BufferedReader r = (BufferedReader)reader;
            for (int i = 0; i < this.skipLines; ++i) {
                r.readLine();
            }
        }
        CSVParser parser = new CSVParser(reader, this.strategy);
        if (this.fieldnames == null) {
            this.fieldnames = parser.getLine();
            if (this.fieldnames == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected fieldnames in CSV input");
            }
            this.prepareFields();
        }
        while (true) {
            int line = parser.getLineNumber();
            String[] vals = parser.getLine();
            if (vals == null) break;
            if (vals.length != this.fields.length) {
                this.input_err("expected " + this.fields.length + " values but got " + vals.length, vals, line);
            }
            this.addDoc(line, vals);
        }
    }

    abstract void addDoc(int var1, String[] var2) throws IOException;

    void doAdd(int line, String[] vals, SolrInputDocument doc, AddUpdateCommand template) throws IOException {
        for (int i = 0; i < vals.length; ++i) {
            if (this.fields[i] == null) continue;
            String val = vals[i];
            this.adders[i].add(doc, line, i, val);
        }
        template.solrDoc = doc;
        this.processor.processAdd(template);
    }

    private class FieldAdder {
        private FieldAdder() {
        }

        void add(SolrInputDocument doc, int line, int column, String val) {
            if (val.length() > 0) {
                doc.addField(CSVLoader.this.fields[column].getName(), (Object)val, 1.0f);
            }
        }
    }

    private class FieldAdderEmpty
    extends FieldAdder {
        private FieldAdderEmpty() {
        }

        void add(SolrInputDocument doc, int line, int column, String val) {
            doc.addField(CSVLoader.this.fields[column].getName(), (Object)val, 1.0f);
        }
    }

    private class FieldMapperSingle
    extends FieldAdder {
        private final String from;
        private final String to;
        private final FieldAdder base;

        FieldMapperSingle(String from, String to, FieldAdder base) {
            this.from = from;
            this.to = to;
            this.base = base;
        }

        void add(SolrInputDocument doc, int line, int column, String val) {
            if (this.from.equals(val)) {
                val = this.to;
            }
            this.base.add(doc, line, column, val);
        }
    }

    private class FieldSplitter
    extends FieldAdder {
        private final CSVStrategy strategy;
        private final FieldAdder base;

        FieldSplitter(CSVStrategy strategy, FieldAdder base) {
            this.strategy = strategy;
            this.base = base;
        }

        void add(SolrInputDocument doc, int line, int column, String val) {
            CSVParser parser = new CSVParser((Reader)new StringReader(val), this.strategy);
            try {
                String[] vals = parser.getLine();
                if (vals != null) {
                    for (String v : vals) {
                        this.base.add(doc, line, column, v);
                    }
                } else {
                    this.base.add(doc, line, column, val);
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
    }

    private class FieldTrimmer
    extends FieldAdder {
        private final FieldAdder base;

        FieldTrimmer(FieldAdder base) {
            this.base = base;
        }

        void add(SolrInputDocument doc, int line, int column, String val) {
            this.base.add(doc, line, column, val.trim());
        }
    }
}

