/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similar.MoreLikeThis;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MoreLikeThisParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;

public class MoreLikeThisHandler
extends RequestHandlerBase {
    private static final Pattern splitList = Pattern.compile(",| ");

    public void init(NamedList args) {
        super.init(args);
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Iterable<ContentStream> streams;
        SolrParams params = req.getParams();
        SolrIndexSearcher searcher = req.getSearcher();
        Reader reader = null;
        String q = params.get("q");
        if ((q == null || q.trim().length() < 1) && (streams = req.getContentStreams()) != null) {
            Iterator<ContentStream> iter = streams.iterator();
            if (iter.hasNext()) {
                reader = iter.next().getReader();
            }
            if (iter.hasNext()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis does not support multiple ContentStreams");
            }
        }
        MoreLikeThisHelper mlt = new MoreLikeThisHelper(params, searcher);
        List<Query> filters = SolrPluginUtils.parseFilterQueries(req);
        MoreLikeThisParams.TermStyle termStyle = MoreLikeThisParams.TermStyle.get((String)params.get("mlt.interestingTerms"));
        ArrayList<InterestingTerm> interesting = termStyle == MoreLikeThisParams.TermStyle.NONE ? null : new ArrayList<InterestingTerm>(mlt.mlt.getMaxQueryTerms());
        String fl = params.get("fl");
        int flags = 0;
        if (fl != null) {
            flags |= SolrPluginUtils.setReturnFields(fl, rsp);
        }
        int start = params.getInt("start", 0);
        int rows = params.getInt("rows", 10);
        DocListAndSet mltDocs = null;
        if (reader != null) {
            mltDocs = mlt.getMoreLikeThis(reader, start, rows, filters, interesting, flags);
        } else if (q != null) {
            DocIterator iterator;
            boolean includeMatch = params.getBool("mlt.match.include", true);
            int matchOffset = params.getInt("mlt.match.offset", 0);
            Query query = QueryParsing.parseQuery(q, params.get("df"), params, req.getSchema());
            DocList match = searcher.getDocList(query, null, null, matchOffset, 1, flags);
            if (includeMatch) {
                rsp.add("match", match);
            }
            if ((iterator = match.iterator()).hasNext()) {
                int id = iterator.nextDoc();
                mltDocs = mlt.getMoreLikeThis(id, start, rows, filters, interesting, flags);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires either a query (?q=) or text to find similar documents.");
        }
        if (mltDocs == null) {
            mltDocs = new DocListAndSet();
        }
        rsp.add("response", mltDocs.docList);
        if (interesting != null) {
            if (termStyle == MoreLikeThisParams.TermStyle.DETAILS) {
                NamedList it = new NamedList();
                for (InterestingTerm t : interesting) {
                    it.add(t.term.toString(), (Object)Float.valueOf(t.boost));
                }
                rsp.add("interestingTerms", it);
            } else {
                ArrayList<String> it = new ArrayList<String>(interesting.size());
                for (InterestingTerm t : interesting) {
                    it.add(t.term.text());
                }
                rsp.add("interestingTerms", it);
            }
        }
        if (params.getBool("facet", false)) {
            if (mltDocs.docSet == null) {
                rsp.add("facet_counts", null);
            } else {
                SimpleFacets f = new SimpleFacets(req, mltDocs.docSet, params);
                rsp.add("facet_counts", f.getFacetCounts());
            }
        }
        try {
            NamedList dbg = SolrPluginUtils.doStandardDebug(req, q, mlt.mltquery, mltDocs.docList);
            if (null != dbg) {
                if (null != filters) {
                    dbg.add("filter_queries", (Object)req.getParams().getParams("fq"));
                    ArrayList<String> fqs = new ArrayList<String>(filters.size());
                    for (Query fq : filters) {
                        fqs.add(QueryParsing.toString(fq, req.getSchema()));
                    }
                    dbg.add("parsed_filter_queries", fqs);
                }
                rsp.add("debug", dbg);
            }
        }
        catch (Exception e) {
            SolrException.logOnce((Logger)SolrCore.log, (String)"Exception during debug", (Throwable)e);
            rsp.add("exception_during_debug", SolrException.toStr((Throwable)e));
        }
    }

    public String getVersion() {
        return "$Revision: 690026 $";
    }

    public String getDescription() {
        return "Solr MoreLikeThis";
    }

    public String getSourceId() {
        return "$Id: MoreLikeThisHandler.java 690026 2008-08-28 22:20:00Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/MoreLikeThisHandler.java $";
    }

    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/MoreLikeThis")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static class InterestingTerm {
        public Term term;
        public float boost;
        public static Comparator<InterestingTerm> BOOST_ORDER = new Comparator<InterestingTerm>(){

            @Override
            public int compare(InterestingTerm t1, InterestingTerm t2) {
                float d = t1.boost - t2.boost;
                if (d == 0.0f) {
                    return 0;
                }
                return d > 0.0f ? 1 : -1;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoreLikeThisHelper {
        final SolrIndexSearcher searcher;
        final MoreLikeThis mlt;
        final IndexReader reader;
        final SchemaField uniqueKeyField;
        final boolean needDocSet;
        Map<String, Float> boostFields;
        Query mltquery;

        public MoreLikeThisHelper(SolrParams params, SolrIndexSearcher searcher) {
            this.searcher = searcher;
            this.reader = searcher.getReader();
            this.uniqueKeyField = searcher.getSchema().getUniqueKeyField();
            this.needDocSet = params.getBool("facet", false);
            RequiredSolrParams required = params.required();
            String[] fields = splitList.split(required.get("mlt.fl"));
            if (fields.length < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: mlt.fl");
            }
            this.mlt = new MoreLikeThis(this.reader);
            this.mlt.setFieldNames(fields);
            this.mlt.setAnalyzer(searcher.getSchema().getAnalyzer());
            this.mlt.setMinTermFreq(params.getInt("mlt.mintf", 2));
            this.mlt.setMinDocFreq(params.getInt("mlt.mindf", 5));
            this.mlt.setMinWordLen(params.getInt("mlt.minwl", 0));
            this.mlt.setMaxWordLen(params.getInt("mlt.maxwl", 0));
            this.mlt.setMaxQueryTerms(params.getInt("mlt.maxqt", 25));
            this.mlt.setMaxNumTokensParsed(params.getInt("mlt.maxntp", 5000));
            this.mlt.setBoost(params.getBool("mlt.boost", false));
            this.boostFields = SolrPluginUtils.parseFieldBoosts(params.getParams("mlt.qf"));
        }

        private void setBoosts(Query mltquery) {
            if (this.boostFields.size() > 0) {
                List clauses = ((BooleanQuery)mltquery).clauses();
                for (Object o : clauses) {
                    TermQuery q = (TermQuery)((BooleanClause)o).getQuery();
                    Float b = this.boostFields.get(q.getTerm().field());
                    if (b == null) continue;
                    q.setBoost(b.floatValue() * q.getBoost());
                }
            }
        }

        public DocListAndSet getMoreLikeThis(int id, int start, int rows, List<Query> filters, List<InterestingTerm> terms, int flags) throws IOException {
            Document doc = this.reader.document(id);
            this.mltquery = this.mlt.like(id);
            this.setBoosts(this.mltquery);
            if (terms != null) {
                this.fillInterestingTermsFromMLTQuery(this.mltquery, terms);
            }
            BooleanQuery mltQuery = new BooleanQuery();
            mltQuery.add(this.mltquery, BooleanClause.Occur.MUST);
            mltQuery.add((Query)new TermQuery(new Term(this.uniqueKeyField.getName(), doc.get(this.uniqueKeyField.getName()))), BooleanClause.Occur.MUST_NOT);
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet((Query)mltQuery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList((Query)mltQuery, filters, null, start, rows, flags);
            }
            return results;
        }

        public DocListAndSet getMoreLikeThis(Reader reader, int start, int rows, List<Query> filters, List<InterestingTerm> terms, int flags) throws IOException {
            this.mltquery = this.mlt.like(reader);
            this.setBoosts(this.mltquery);
            if (terms != null) {
                this.fillInterestingTermsFromMLTQuery(this.mltquery, terms);
            }
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet(this.mltquery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList(this.mltquery, filters, null, start, rows, flags);
            }
            return results;
        }

        public NamedList<DocList> getMoreLikeThese(DocList docs, int rows, int flags) throws IOException {
            IndexSchema schema = this.searcher.getSchema();
            SimpleOrderedMap mlt = new SimpleOrderedMap();
            DocIterator iterator = docs.iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextDoc();
                DocListAndSet sim = this.getMoreLikeThis(id, 0, rows, null, null, flags);
                String name = schema.printableUniqueKey(this.reader.document(id));
                mlt.add(name, (Object)sim.docList);
            }
            return mlt;
        }

        private void fillInterestingTermsFromMLTQuery(Query query, List<InterestingTerm> terms) {
            List clauses = ((BooleanQuery)this.mltquery).clauses();
            for (Object o : clauses) {
                TermQuery q = (TermQuery)((BooleanClause)o).getQuery();
                InterestingTerm it = new InterestingTerm();
                it.boost = q.getBoost();
                it.term = q.getTerm();
                terms.add(it);
            }
        }

        public MoreLikeThis getMoreLikeThis() {
            return this.mlt;
        }
    }
}

